//=============================================================================
// ChallengeHUD
// Heads up display
//=============================================================================
class Respawnables_HUD extends HUD config(User);

#exec OBJ LOAD FILE=..\Textures\LadrStatic.utx PACKAGE=Botpack.LadrStatic

//Respawnables info:
var string 	Version,
			Copyright;

//Player key:
var config string RespawnablesID;
var bool bIDset;

//Weapon vars:
var Weapon	CurrentWeapon;
var bool	bWeaponSwitched;
var color	WeaponDrawColor;

//Radar vars:
var color LightCyanColor, RadarColor, HUDelementColor;
var float LastDrawRadar, RadarScale, RadarPosX, RadarPosY, RadarPulse;

//Sync color:
var color SyncColor;
var bool bSynColor; //switch to handle up/down color fading

//Menu variables:
var string	Category;		//Weapons(default), Gear, Mental or Game
var int		ItemNumber;		//holds info about what item is currently selected(default=0, reset if category is changed)
var bool	bKeyPressed;	//True when player holds down nav keys
//Menu, Weapons:
var string	WeaponsItem[64];//Holds the weapon string item name
var string	WeaponsInfo[64];//Holds the weapon string item info
var string	WeaponInfoB[64];//Holds additional info e.g. mutate commands
var int		WeaponPrice[64];//Holds the weapons cost price
var texture WeaponsText[64];//Holds the weapon texture
var string	WeaponsCom[64];	//Holds the weapon string mutate command
var string	WeaponAlias[64];//Holds the alias for the weapon e.g.: #SR = ShockRifle, #SN = SniperRifle
//Menu, Gear:
var string	GearsItem[64];	//Holds the Gear string item name
var string	GearsInfo[64];	//Holds the Gear string item info
var string	GearsInfoB[64];	//Holds additional info e.g. mutate commands
var int		GearPrice[64];	//Holds the Gear cost price
var texture GearsText[64];	//Holds the Gear texture
var string	GearsCom[64];	//Holds the Gear string mutate command
var string	GearAlias[64];	//Holds the alias for the gear e.g.: #AR = Armor, #SB = ShieldBelt
//Menu, Mental:
var string	MentalsItem[64];//Holds the Mental string item name
var string	MentalsInfo[64];//Holds the Mental string item info
var string	MentalInfoB[64];//Holds additional info e.g. mutate commands
var int		MentalPrice[64];//Holds the Mental cost price
var texture MentalsText[64];//Holds the Mental texture
var string	MentalsCom[64];	//Holds the Mental string mutate command
var string	MentalAlias[64];//Holds the alias for the mental e.g.: #SH = Sould Harvest, #LA = Lethal Aura
//Menu, Game:
var string	GameText;		//Holds the info string about how to start game

var() int SizeY,Count;
var string CurrentMessage;
var float MOTDFadeOutTime;

var float IdentifyFadeTime;
var PlayerReplicationInfo IdentifyTarget;
var Pawn PawnOwner;	// pawn currently managing this HUD (may be the viewtarget of the owner rather than the owner)
var FontInfo MyFonts;

// Localized Messages
var HUDLocalizedMessage ShortMessageQueue[4];
var HUDLocalizedMessage LocalMessages[10];

var texture FaceTexture;
var float FaceTime;
var color FaceTeam;
 
var() localized string VersionMessage, PlayerCountString;
var localized string MapTitleString, AuthorString;
var localized string MapTitleString2, AuthorString2;

var localized string RankString;
var localized string SpreadString;

var int PlayerCount;
var bool bTiedScore;

var string ReceivedMessage;
var string ReceivedName;
var ZoneInfo ReceivedZone;
var float ReceivedTime;
var texture TutIconTex;
var int TutIconX, TutIconY;
var float TutIconBlink;

var globalconfig int CrosshairCount;
var globalconfig string CrossHairs[20];
var texture CrossHairTextures[20];

var texture GrayWeapons[11];
var texture FP1[3], FP2[3], FP3[3];
var int LastReportedTime;
var bool bStartUpMessage, bForceScores;
var bool bTimeValid;
var bool bLowRes;
var bool bResChanged;
var int OldClipX;

// configuration options
var bool bAlwaysHideFrags, bHideCenterMessages;
var globalconfig bool bHideAllWeapons, bHideStatus, bHideAmmo, bHideTeamInfo, bHideFrags, bHideHUD, bHideNoviceMessages, bHideFaces;
var globalconfig bool bUseTeamColor;
var globalconfig byte Opacity;	// should be between 1 and 16
var globalconfig float HUDScale, StatusScale, WeaponScale;
var globalconfig color FavoriteHUDColor, CrosshairColor;
var float Scale;
var byte Style;
var color BaseColor, WhiteColor, RedColor, GreenColor, CyanColor, UnitColor, BlueColor,
		 GoldColor, HUDColor, SolidHUDColor, PurpleColor, TurqColor, GrayColor, FaceColor;

// Identify Strings
var localized string IdentifyName, IdentifyHealth, IdentifyCallsign;
var localized string LiveFeed;

// scoring 
var float ScoreTime;
var int rank, lead;

// showing damage
var vector HitPos[4];
var float HitTime[4];
var float HitDamage[4];

var float PickupTime;

var float WeaponNameFade;
var float MessageFadeTime;
var int MessageFadeCount;
var bool bDrawMessageArea;
var bool bDrawFaceArea;
var float FaceAreaOffset, MinFaceAreaOffset;
var class<CriticalEventPlus> TimeMessageClass;

// Server info.
var ServerInfo ServerInfo;
var bool bShowInfo;

var class<ServerInfo> ServerInfoClass;

var globalconfig string FontInfoClass;

function CreateID()
{
local int i, ii, dice;

	RespawnablesID = "";
	for (ii=0;ii<3;ii++)
		{
		for (i=0;i<4;i++)
			{
			Dice = Rand(10);
			RespawnablesID = RespawnablesID$Dice;
			}
		if ( ii < 2 )
			{
			RespawnablesID = RespawnablesID$"-";
			}
		}
}

function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

function SetDamage(vector HitLoc, float damage)
{
}

simulated function PostBeginPlay()
{
	local int i;

	if ( Level.NetMode != NM_Standalone )
		MOTDFadeOutTime = 350;
	FaceAreaOffset = -64;
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(FontInfoClass, class'Class'))));
	Super.PostBeginPlay();
	SetTimer(1.0, True);

	if ( (PlayerPawn(Owner).GameReplicationInfo != None)
		&& (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) )
		TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

	ServerInfo = Spawn(ServerInfoClass, Owner);
}

exec function SetHUDR(int n)
{
	FavoriteHUDColor.R = Clamp(n,0,16);
}

exec function SetHUDG(int n)
{
	FavoriteHUDColor.G = Clamp(n,0,16);
}

exec function SetHUDB(int n)
{
	FavoriteHUDColor.B = Clamp(n,0,16);
}

exec function ShowServerInfo()
{
	if (bShowInfo)
	{
		bShowInfo = False;
	} else {
		bShowInfo = True;
		PlayerPawn(Owner).bShowScores = False;
	}
}

exec function GrowHUD()
{
	if ( bHideHUD )
		bHideHud = false;
	else if ( bHideAmmo )
		bHideAmmo = false;
	else if ( bHideFrags )
		bHideFrags = false;
	else if ( bHideTeamInfo )
		bHideTeamInfo = false;
	else if ( bHideAllWeapons )
		bHideAllWeapons = false;
	else if ( bHideStatus )
		bHideStatus = false;
	else 
		WeaponScale = 1.0;

	SaveConfig();
}

exec function ShrinkHUD()
{
	if ( !bLowRes && (WeaponScale * HUDScale > 0.8) )
		WeaponScale = 0.8/HUDScale;
	else if ( !bHideStatus )
		bHideStatus = true;
	else if ( !bHideAllWeapons )
		bHideAllWeapons = true;
	else if ( !bHideTeamInfo )
		bHideTeamInfo = true;
	else if ( !bHideFrags )
		bHideFrags = true;
	else if ( !bHideAmmo )
		bHideAmmo = true;
	else
		bHideHud = true;

	SaveConfig();
}
	
simulated function ChangeCrosshair(int d)
{
	Crosshair = Crosshair + d;
	if ( Crosshair >= CrossHairCount )
		Crosshair = 0;
	else
	if ( Crosshair < 0 )
		Crosshair = CrossHairCount-1;
}

simulated function Texture LoadCrosshair(int c)
{
	CrossHairTextures[c] = Texture(DynamicLoadObject(CrossHairs[c], class'Texture'));
	return CrossHairTextures[c];
}

simulated function HUDSetup(canvas canvas)
{
	local int FontSize;

	bResChanged = (Canvas.ClipX != OldClipX);
	OldClipX = Canvas.ClipX;
		
	PlayerOwner = PlayerPawn(Owner);
	if ( PlayerOwner.ViewTarget == None )
		PawnOwner = PlayerOwner;
	else if ( PlayerOwner.ViewTarget.bIsPawn )
		PawnOwner = Pawn(PlayerOwner.ViewTarget);
	else 
		PawnOwner = PlayerOwner;

	// Setup the way we want to draw all HUD elements
	Canvas.Reset();
	Canvas.SpaceX=0;
	Canvas.bNoSmooth = True;

	FontSize = Min(3, HUDScale * Canvas.ClipX/500);
	Scale = (HUDScale * Canvas.ClipX)/1280.0;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );

	SolidHUDColor = FavoriteHUDColor * 15.9;
	if ( (Opacity == 16) || !Level.bHighDetailMode )
	{
		Style = ERenderStyle.STY_Normal;
		BaseColor = WhiteColor;
		HUDColor = SolidHUDColor;
	}
	else
	{
		Style = ERenderStyle.STY_Translucent;
		BaseColor = (16 * Opacity + 15) * UnitColor;
		HUDColor = FavoriteHUDColor * (Opacity + 0.9);
	}
	Canvas.DrawColor = BaseColor;
	Canvas.Style = Style;
	bLowRes = ( Canvas.ClipX < 400 );
	if ( bLowRes )
		WeaponScale = 1.0;
}

simulated function DrawSyncing(Canvas Canvas)
{
local float XL,YL;
local float Scale;
local Respawnables_PRI PRI;

	PRI = Respawnables_PRI(PlayerPawn(PawnOwner).PlayerReplicationInfo);
	
	DrawBackground(Canvas);
	
	//Draw please wait message:
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.bCenter = True;
	Canvas.StrLen("Please wait", XL, YL);
	Canvas.SetPos(2, Canvas.ClipY * 0.5 - 2 * YL + 2);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor * 0.1; 
	Canvas.DrawText("Please wait", False);
	Canvas.SetPos(0, Canvas.ClipY * 0.5 - 2 * YL);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor; 
	Canvas.DrawText("Please wait", False);
	Canvas.bCenter = True;
	
	//Handle players sync status:
	if ( PRI != None )
		{
		DrawSyncStep(Canvas);
		
		//Handle Sync color:
		if ( !bSynColor )
			{
			SyncColor.R += 3;
			SyncColor.G += 3;
			SyncColor.B += 3;
			if ( SyncColor.R > 255 )
				{
				SyncColor.R = 255;
				SyncColor.G = 255;
				SyncColor.B = 255;
				bSynColor = True;
				}
			}
		else
			{
			SyncColor.R -= 3;
			SyncColor.G -= 3;
			SyncColor.B -= 3;
			if ( SyncColor.R < 0 )
				{
				SyncColor.R = 0;
				SyncColor.G = 0;
				SyncColor.B = 0;
				bSynColor = False;
				}
			}
		}
}

simulated function DrawBackground(Canvas Canvas)
{
local float Scale,XL,YL;

	Scale = Canvas.ClipX / 1024;
	if ( Scale > 1 )
		Scale = 1;
	Canvas.DrawColor = WhiteColor;
	
	//Draw background:
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(0, 0);
	Canvas.DrawTile(Texture'reShopBase', Canvas.ClipX, Canvas.ClipY, 0, 0, 1024, 768);
	
	//Draw Respawnables logo:
	Canvas.SetPos(Canvas.ClipX * 0.5 - 512 * Scale, 0);
	Canvas.Style = ERenderStyle.STY_Masked;
	Canvas.DrawTile(Texture'Respawnables', 1024 * Scale, 128 * Scale, 0, 0, 1024, 128);
	
	//Draw Version and Copyright notice:
	Canvas.Font = MyFonts.GetSmallestFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor * 0.1;
	Canvas.StrLen(Version, XL, YL);
	Canvas.SetPos(1, Canvas.ClipY - YL + 1);
	Canvas.DrawText(Version, False);
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(0, Canvas.ClipY - YL);
	Canvas.DrawText(Version, False);
	Canvas.bCenter = True;
	Canvas.DrawColor = WhiteColor * 0.1;
	Canvas.SetPos(1, Canvas.ClipY - YL + 1);
	Canvas.DrawText(Copyright, False);
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(0, Canvas.ClipY - YL);
	Canvas.DrawText(Copyright, False);
	Canvas.bCenter = False;
}

simulated function DrawMenuFrame(Canvas Canvas)
{
local float XL,YL;

	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.StrLen("(TEST)", XL, YL);
	Canvas.DrawColor = WhiteColor * 0.2;
	
	//Draw Background (800*450 hardcoded and centered)
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 400, Canvas.ClipY * 0.5 - 225);
	Canvas.DrawTile(Texture'reMenuBackground', 800, 450, 0, 0, 800, 450);
	
	//Top Line
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 400, Canvas.ClipY * 0.5 - 225);
	Canvas.DrawTile(Texture'reWhite', 800, 1, 0, 0, 800, 1);
	Canvas.DrawColor = WhiteColor * 0.5;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 400, Canvas.ClipY * 0.5 - 224);
	Canvas.DrawTile(Texture'reWhite', 800, 4, 0, 0, 800, 1);
	Canvas.DrawColor = WhiteColor * 0.2;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 400, Canvas.ClipY * 0.5 - 220);
	Canvas.DrawTile(Texture'reWhite', 800, 1, 0, 0, 800, 1);
	
	//Bottom Line
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 400, Canvas.ClipY * 0.5 + 219);
	Canvas.DrawTile(Texture'reWhite', 800, 1, 0, 0, 800, 1);
	Canvas.DrawColor = WhiteColor * 0.5;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 400, Canvas.ClipY * 0.5 + 220);
	Canvas.DrawTile(Texture'reWhite', 800, 4, 0, 0, 800, 1);
	Canvas.DrawColor = WhiteColor * 0.2;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 400, Canvas.ClipY * 0.5 + 224);
	Canvas.DrawTile(Texture'reWhite', 800, 1, 0, 0, 800, 1);
	
	//Left Line
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 400, Canvas.ClipY * 0.5 - 225);
	Canvas.DrawTile(Texture'reWhite', 1, 450, 0, 0, 1, 450);
	Canvas.DrawColor = WhiteColor * 0.5;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 399, Canvas.ClipY * 0.5 - 224);
	Canvas.DrawTile(Texture'reWhite', 4, 448, 0, 0, 4, 448);
	Canvas.DrawColor = WhiteColor * 0.2;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 395, Canvas.ClipY * 0.5 - 220);
	Canvas.DrawTile(Texture'reWhite', 1, 440, 0, 0, 1, 440);
	
	//Right Line
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 394, Canvas.ClipY * 0.5 - 220);
	Canvas.DrawTile(Texture'reWhite', 1, 440, 0, 0, 1, 440);
	Canvas.DrawColor = WhiteColor * 0.5;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 395, Canvas.ClipY * 0.5 - 224);
	Canvas.DrawTile(Texture'reWhite', 4, 448, 0, 0, 4, 448);
	Canvas.DrawColor = WhiteColor * 0.2;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 399, Canvas.ClipY * 0.5 - 224);
	Canvas.DrawTile(Texture'reWhite', 1, 449, 0, 0, 1, 449);
	
	//ItemName UnderLine
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 395, Canvas.ClipY * 0.5 - 220 + YL);
	Canvas.DrawTile(Texture'reWhite', 790, 1, 0, 0, 790, 1);
	Canvas.DrawColor = WhiteColor * 0.5;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 395, Canvas.ClipY * 0.5 - 219 + YL);
	Canvas.DrawTile(Texture'reWhite', 790, 4, 0, 0, 790, 1);
	Canvas.DrawColor = WhiteColor * 0.2;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 395, Canvas.ClipY * 0.5 - 215 + YL);
	Canvas.DrawTile(Texture'reWhite', 790, 1, 0, 0, 790, 1);
	
	//Line above item text
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 395, Canvas.ClipY * 0.5 + 215 - 2*YL);
	Canvas.DrawTile(Texture'reWhite', 790, 1, 0, 0, 790, 1);
	Canvas.DrawColor = WhiteColor * 0.5;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 395, Canvas.ClipY * 0.5 + 216 - 2*YL);
	Canvas.DrawTile(Texture'reWhite', 790, 4, 0, 0, 790, 1);
	Canvas.DrawColor = WhiteColor * 0.2;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 395, Canvas.ClipY * 0.5 + 220 - 2*YL);
	Canvas.DrawTile(Texture'reWhite', 790, 1, 0, 0, 790, 1);
}

simulated function DrawMenuCategory(Canvas Canvas)
{
local float XL1,XL2,XL3,XL4,YL;
local string Title[4];

	Title[0] = "Weapons";
	Title[1] = "Gear";
	Title[2] = "Mental";
	Title[3] = "Game";
	
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;
	
	Canvas.StrLen(Title[0], XL1, YL);
	Canvas.StrLen(Title[1], XL2, YL);
	Canvas.StrLen(Title[2], XL3, YL);
	Canvas.StrLen(Title[3], XL4, YL);
	
	//Title1:
	Canvas.SetPos(Canvas.ClipX * 0.5 - 400, Canvas.ClipY * 0.5 - 225 - YL);
	if ( Title[0] == Category )
		Canvas.DrawColor = WhiteColor;
	else
		Canvas.DrawColor = WhiteColor * 0.3;
	Canvas.DrawText(Title[0], False);
	
	//Title2:
	Canvas.SetPos(Canvas.ClipX * 0.5 - 400 + XL1 + 16, Canvas.ClipY * 0.5 - 225 - YL);
	if ( Title[1] == Category )
		Canvas.DrawColor = WhiteColor;
	else
		Canvas.DrawColor = WhiteColor * 0.3;
	Canvas.DrawText(Title[1], False);

	//Title3:
	Canvas.SetPos(Canvas.ClipX * 0.5 - 400 + XL1 + XL2 + 2*16, Canvas.ClipY * 0.5 - 225 - YL);
	if ( Title[2] == Category )
		Canvas.DrawColor = WhiteColor;
	else
		Canvas.DrawColor = WhiteColor * 0.3;
	Canvas.DrawText(Title[2], False);
	
	//Title4:
	Canvas.SetPos(Canvas.ClipX * 0.5 - 400 + XL1 + XL2 + XL3 + 3*16, Canvas.ClipY * 0.5 - 225 - YL);
	if ( Title[3] == Category )
		Canvas.DrawColor = WhiteColor;
	else
		Canvas.DrawColor = WhiteColor * 0.3;
	Canvas.DrawText(Title[3], False);
}

simulated function DrawMenuMoney(Canvas Canvas)
{
local float XL,YL;
local Respawnables_PRI PRI;

	PRI = Respawnables_PRI(PlayerPawn(PawnOwner).PlayerReplicationInfo);
	
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;
	
	Canvas.StrLen("You currently have $"$PRI.Money$" to shop for.", XL, YL);


	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY * 0.5 + 219 - YL);
	Canvas.DrawColor = WhiteColor;
	Canvas.DrawText("You currently have $"$PRI.Money$" to shop for.", False);
}

simulated function DrawHighlightArrows(Canvas Canvas,float Xpos,float XL,float Ypos,float YL)
{
	Canvas.Style = ERenderStyle.STY_Masked;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Xpos - 0.5 * XL - YL, Ypos);
	Canvas.DrawTile(texture'reArrowRight', YL, YL, 0, 0, 128, 128);
	Canvas.SetPos(Xpos + 0.5 * XL, Ypos);
	Canvas.DrawTile(texture'reArrowLeft', YL, YL, 0, 0, 128, 128);
	Canvas.Style = ERenderStyle.STY_Normal;
}

simulated function DrawMenuWeapons(Canvas Canvas)
{
local float XL,YL,Xpos,Ypos;
local Respawnables_PRI PRI;
local bool bCanBuy;

	PRI = Respawnables_PRI(PlayerPawn(PawnOwner).PlayerReplicationInfo);
	if ( PRI.Money >= WeaponPrice[ItemNumber] )
		bCanBuy = True;
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;
	
	//Draw item name:
	Canvas.StrLen(WeaponsItem[ItemNumber]$" ($"$WeaponPrice[ItemNumber]$")", XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY * 0.5 - 220);
	if ( bCanBuy )
		Canvas.DrawColor = GreenColor;
	else
		Canvas.DrawColor = RedColor;
	Canvas.DrawText(WeaponsItem[ItemNumber]$" ($"$WeaponPrice[ItemNumber]$")", False);
	
	//Draw item info:
	Canvas.StrLen(WeaponsInfo[ItemNumber], XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY * 0.5 + 219 - 2*YL);
	Canvas.DrawText(WeaponsInfo[ItemNumber], False);
	if ( WeaponInfoB[ItemNumber] != "" )
		{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen(WeaponInfoB[ItemNumber], XL, YL);
		Canvas.SetPos(Canvas.ClipX * 0.5 + 160 - 0.5 * XL, Canvas.ClipY * 0.5 + 132 - YL);
		Canvas.DrawText(WeaponInfoB[ItemNumber], False);
		}
	
	//Draw weapon frame:
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 392, Canvas.ClipY * 0.5 - 177);
	Canvas.DrawTile(texture'reMetalFrame', 320, 320, 48, 48, 416, 416);
	
	//Draw item texture:
	Canvas.SetPos(Canvas.ClipX * 0.5 - 392 + 32, Canvas.ClipY * 0.5 - 128);
	Canvas.DrawTile(WeaponsText[ItemNumber], 256, 256, 0, 0, 256, 256);
	
	//Draw possible checkmark:
	if ( InStr(PRI.WeaponString, WeaponAlias[ItemNumber]) != -1 )
		{
		Canvas.SetPos(Canvas.ClipX * 0.5 - 392 + 32 + 128, Canvas.ClipY * 0.5 );
		Canvas.DrawTile(Texture'reCheckmark', 128, 128, 0, 0, 128, 128);
		}
	
	Xpos = Canvas.ClipX * 0.5 + 160;
	Ypos = Canvas.ClipY * 0.5 - 100;
	
	//Draw 1st Weapon on name list:
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );	
	if ( ItemNumber >= 3 )
		{
		Canvas.StrLen(WeaponsItem[ItemNumber - 3], XL, YL);
		Canvas.DrawColor = WhiteColor * 0.3;
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
		Canvas.DrawText(WeaponsItem[ItemNumber - 3], False);
		Ypos += YL;
		}
	else
		{
		Canvas.StrLen("TEST", XL, YL);
		Ypos += YL;
		}
		
	//Draw 2nd Weapon on name list:
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );	
	if ( ItemNumber >= 2 )
		{
		Canvas.StrLen(WeaponsItem[ItemNumber - 2], XL, YL);
		Canvas.DrawColor = WhiteColor * 0.5;
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
		Canvas.DrawText(WeaponsItem[ItemNumber - 2], False);
		Ypos += YL;
		}
	else
		{
		Canvas.StrLen("TEST", XL, YL);
		Ypos += YL;
		}
		
	//Draw 3rd Weapon on name list:
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );	
	if ( ItemNumber >= 1 )
		{
		Canvas.StrLen(WeaponsItem[ItemNumber - 1], XL, YL);
		Canvas.DrawColor = WhiteColor * 0.7;
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
		Canvas.DrawText(WeaponsItem[ItemNumber - 1], False);
		Ypos += YL;
		}
	else
		{
		Canvas.StrLen("TEST", XL, YL);
		Ypos += YL;
		}
	
	//Draw 4th Weapon on name list:
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );	
	Canvas.StrLen(WeaponsItem[ItemNumber], XL, YL);
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
	Canvas.DrawText(WeaponsItem[ItemNumber], False);
	//Draw arrow highlights of weapon selected:
	DrawHighlightArrows(Canvas,Xpos,XL,Ypos,YL);
	Ypos += YL;
	
	//Draw 5th Weapon on name list:
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );	
	if ( ItemNumber < 63 && WeaponsItem[ItemNumber + 1] != "" )
		{
		Canvas.StrLen(WeaponsItem[ItemNumber + 1], XL, YL);
		Canvas.DrawColor = WhiteColor * 0.7;
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
		Canvas.DrawText(WeaponsItem[ItemNumber + 1], False);
		Ypos += YL;
		}
	else
		{
		Canvas.StrLen("TEST", XL, YL);
		Ypos += YL;
		}
		
	//Draw 6th Weapon on name list:
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );	
	if ( ItemNumber < 62 && WeaponsItem[ItemNumber + 2] != "" )
		{
		Canvas.StrLen(WeaponsItem[ItemNumber + 2], XL, YL);
		Canvas.DrawColor = WhiteColor * 0.5;
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
		Canvas.DrawText(WeaponsItem[ItemNumber + 2], False);
		Ypos += YL;
		}
	else
		{
		Canvas.StrLen("TEST", XL, YL);
		Ypos += YL;
		}
	
	//Draw 7th Weapon on name list:
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );	
	if ( ItemNumber < 61 && WeaponsItem[ItemNumber + 3] != "" )
		{
		Canvas.StrLen(WeaponsItem[ItemNumber + 3], XL, YL);
		Canvas.DrawColor = WhiteColor * 0.3;
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
		Canvas.DrawText(WeaponsItem[ItemNumber + 3], False);
		Ypos += YL;
		}
	else
		{
		Canvas.StrLen("TEST", XL, YL);
		Ypos += YL;
		}
}

simulated function DrawMenuGear(Canvas Canvas)
{
local float XL,YL,Xpos,Ypos;
local Respawnables_PRI PRI;
local bool bCanBuy;

	PRI = Respawnables_PRI(PlayerPawn(PawnOwner).PlayerReplicationInfo);
	if ( PRI.Money >= GearPrice[ItemNumber] )
		bCanBuy = True;
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;
	
	//Draw item name:
	Canvas.StrLen(GearsItem[ItemNumber]$" ($"$GearPrice[ItemNumber]$")", XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY * 0.5 - 220);
	if ( bCanBuy )
		Canvas.DrawColor = GreenColor;
	else
		Canvas.DrawColor = RedColor;
	Canvas.DrawText(GearsItem[ItemNumber]$" ($"$GearPrice[ItemNumber]$")", False);
	
	//Draw item info:
	Canvas.StrLen(GearsInfo[ItemNumber], XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY * 0.5 + 219 - 2*YL);
	Canvas.DrawText(GearsInfo[ItemNumber], False);
	if ( GearsInfoB[ItemNumber] != "" )
		{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen(GearsInfoB[ItemNumber], XL, YL);
		Canvas.SetPos(Canvas.ClipX * 0.5 + 160 - 0.5 * XL, Canvas.ClipY * 0.5 + 132 - YL);
		Canvas.DrawText(GearsInfoB[ItemNumber], False);
		}
	
	//Draw Gear frame:
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 392, Canvas.ClipY * 0.5 - 177);
	Canvas.DrawTile(texture'reMetalFrame', 320, 320, 48, 48, 416, 416);
	
	//Draw item texture:
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 392 + 32, Canvas.ClipY * 0.5 - 128);
	Canvas.DrawTile(GearsText[ItemNumber], 256, 256, 0, 0, 256, 256);
	
	//Draw possible checkmark:
	if ( InStr(PRI.InventoryString, GearAlias[ItemNumber]) != -1 )
		{
		Canvas.SetPos(Canvas.ClipX * 0.5 - 392 + 32 + 128, Canvas.ClipY * 0.5 );
		Canvas.DrawTile(Texture'reCheckmark', 128, 128, 0, 0, 128, 128);
		}
	
	Xpos = Canvas.ClipX * 0.5 + 160;
	Ypos = Canvas.ClipY * 0.5 - 100;
	
	//Draw 1st Gear on name list:
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );	
	if ( ItemNumber >= 3 )
		{
		Canvas.StrLen(GearsItem[ItemNumber - 3], XL, YL);
		Canvas.DrawColor = WhiteColor * 0.3;
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
		Canvas.DrawText(GearsItem[ItemNumber - 3], False);
		Ypos += YL;
		}
	else
		{
		Canvas.StrLen("TEST", XL, YL);
		Ypos += YL;
		}
		
	//Draw 2nd Gear on name list:
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );	
	if ( ItemNumber >= 2 )
		{
		Canvas.StrLen(GearsItem[ItemNumber - 2], XL, YL);
		Canvas.DrawColor = WhiteColor * 0.5;
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
		Canvas.DrawText(GearsItem[ItemNumber - 2], False);
		Ypos += YL;
		}
	else
		{
		Canvas.StrLen("TEST", XL, YL);
		Ypos += YL;
		}
		
	//Draw 3rd Gear on name list:
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );	
	if ( ItemNumber >= 1 )
		{
		Canvas.StrLen(GearsItem[ItemNumber - 1], XL, YL);
		Canvas.DrawColor = WhiteColor * 0.7;
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
		Canvas.DrawText(GearsItem[ItemNumber - 1], False);
		Ypos += YL;
		}
	else
		{
		Canvas.StrLen("TEST", XL, YL);
		Ypos += YL;
		}
	
	//Draw 4th Gear on name list:
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );	
	Canvas.StrLen(GearsItem[ItemNumber], XL, YL);
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
	Canvas.DrawText(GearsItem[ItemNumber], False);
	//Draw arrow highlights of gear selected:
	DrawHighlightArrows(Canvas,Xpos,XL,Ypos,YL);
	Ypos += YL;
	
	//Draw 5th Gear on name list:
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );	
	if ( ItemNumber < 63 && GearsItem[ItemNumber + 1] != "" )
		{
		Canvas.StrLen(GearsItem[ItemNumber + 1], XL, YL);
		Canvas.DrawColor = WhiteColor * 0.7;
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
		Canvas.DrawText(GearsItem[ItemNumber + 1], False);
		Ypos += YL;
		}
	else
		{
		Canvas.StrLen("TEST", XL, YL);
		Ypos += YL;
		}
		
	//Draw 6th Gear on name list:
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );	
	if ( ItemNumber < 62 && GearsItem[ItemNumber + 2] != "" )
		{
		Canvas.StrLen(GearsItem[ItemNumber + 2], XL, YL);
		Canvas.DrawColor = WhiteColor * 0.5;
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
		Canvas.DrawText(GearsItem[ItemNumber + 2], False);
		Ypos += YL;
		}
	else
		{
		Canvas.StrLen("TEST", XL, YL);
		Ypos += YL;
		}
	
	//Draw 7th Gear on name list:
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );	
	if ( ItemNumber < 61 && GearsItem[ItemNumber + 3] != "" )
		{
		Canvas.StrLen(GearsItem[ItemNumber + 3], XL, YL);
		Canvas.DrawColor = WhiteColor * 0.3;
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
		Canvas.DrawText(GearsItem[ItemNumber + 3], False);
		Ypos += YL;
		}
	else
		{
		Canvas.StrLen("TEST", XL, YL);
		Ypos += YL;
		}
}

simulated function DrawMenuMental(Canvas Canvas)
{
local float XL,YL,Xpos,Ypos;
local Respawnables_PRI PRI;
local bool bCanBuy;

	PRI = Respawnables_PRI(PlayerPawn(PawnOwner).PlayerReplicationInfo);
	if ( PRI.Money >= MentalPrice[ItemNumber] )
		bCanBuy = True;
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;
	
	//Draw item name:
	Canvas.StrLen(MentalsItem[ItemNumber]$" ($"$MentalPrice[ItemNumber]$")", XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY * 0.5 - 220);
	if ( bCanBuy )
		Canvas.DrawColor = GreenColor;
	else
		Canvas.DrawColor = RedColor;
	Canvas.DrawText(MentalsItem[ItemNumber]$" ($"$MentalPrice[ItemNumber]$")", False);
	
	//Draw item info:
	Canvas.StrLen(MentalsInfo[ItemNumber], XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY * 0.5 + 219 - 2*YL);
	Canvas.DrawText(MentalsInfo[ItemNumber], False);
	if ( MentalInfoB[ItemNumber] != "" )
		{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen(MentalInfoB[ItemNumber], XL, YL);
		Canvas.SetPos(Canvas.ClipX * 0.5 + 160 - 0.5 * XL, Canvas.ClipY * 0.5 + 132 - YL);
		Canvas.DrawText(MentalInfoB[ItemNumber], False);
		}
		
	//Draw Mental frame:
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 392, Canvas.ClipY * 0.5 - 177);
	Canvas.DrawTile(texture'reMetalFrame', 320, 320, 48, 48, 416, 416);
	
	//Draw item texture:
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 392 + 32, Canvas.ClipY * 0.5 - 128);
	Canvas.DrawTile(MentalsText[ItemNumber], 256, 256, 0, 0, 256, 256);
	
	//Draw possible checkmark:
	if ( InStr(PRI.InventoryString, MentalAlias[ItemNumber]) != -1 )
		{
		Canvas.SetPos(Canvas.ClipX * 0.5 - 392 + 32 + 128, Canvas.ClipY * 0.5 );
		Canvas.DrawTile(Texture'reCheckmark', 128, 128, 0, 0, 128, 128);
		}
	
	Xpos = Canvas.ClipX * 0.5 + 160;
	Ypos = Canvas.ClipY * 0.5 - 100;
	
	//Draw 1st Mental on name list:
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );	
	if ( ItemNumber >= 3 )
		{
		Canvas.StrLen(MentalsItem[ItemNumber - 3], XL, YL);
		Canvas.DrawColor = WhiteColor * 0.3;
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
		Canvas.DrawText(MentalsItem[ItemNumber - 3], False);
		Ypos += YL;
		}
	else
		{
		Canvas.StrLen("TEST", XL, YL);
		Ypos += YL;
		}
		
	//Draw 2nd Mental on name list:
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );	
	if ( ItemNumber >= 2 )
		{
		Canvas.StrLen(MentalsItem[ItemNumber - 2], XL, YL);
		Canvas.DrawColor = WhiteColor * 0.5;
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
		Canvas.DrawText(MentalsItem[ItemNumber - 2], False);
		Ypos += YL;
		}
	else
		{
		Canvas.StrLen("TEST", XL, YL);
		Ypos += YL;
		}
		
	//Draw 3rd Mental on name list:
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );	
	if ( ItemNumber >= 1 )
		{
		Canvas.StrLen(MentalsItem[ItemNumber - 1], XL, YL);
		Canvas.DrawColor = WhiteColor * 0.7;
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
		Canvas.DrawText(MentalsItem[ItemNumber - 1], False);
		Ypos += YL;
		}
	else
		{
		Canvas.StrLen("TEST", XL, YL);
		Ypos += YL;
		}
	
	//Draw 4th Mental on name list:
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );	
	Canvas.StrLen(MentalsItem[ItemNumber], XL, YL);
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
	Canvas.DrawText(MentalsItem[ItemNumber], False);
	//Draw arrow highlights of mental selected:
	DrawHighlightArrows(Canvas,Xpos,XL,Ypos,YL);
	Ypos += YL;
	
	//Draw 5th Mental on name list:
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );	
	if ( ItemNumber < 63 && MentalsItem[ItemNumber + 1] != "" )
		{
		Canvas.StrLen(MentalsItem[ItemNumber + 1], XL, YL);
		Canvas.DrawColor = WhiteColor * 0.7;
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
		Canvas.DrawText(MentalsItem[ItemNumber + 1], False);
		Ypos += YL;
		}
	else
		{
		Canvas.StrLen("TEST", XL, YL);
		Ypos += YL;
		}
		
	//Draw 6th Mental on name list:
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );	
	if ( ItemNumber < 62 && MentalsItem[ItemNumber + 2] != "" )
		{
		Canvas.StrLen(MentalsItem[ItemNumber + 2], XL, YL);
		Canvas.DrawColor = WhiteColor * 0.5;
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
		Canvas.DrawText(MentalsItem[ItemNumber + 2], False);
		Ypos += YL;
		}
	else
		{
		Canvas.StrLen("TEST", XL, YL);
		Ypos += YL;
		}
	
	//Draw 7th Mental on name list:
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );	
	if ( ItemNumber < 61 && MentalsItem[ItemNumber + 3] != "" )
		{
		Canvas.StrLen(MentalsItem[ItemNumber + 3], XL, YL);
		Canvas.DrawColor = WhiteColor * 0.3;
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
		Canvas.DrawText(MentalsItem[ItemNumber + 3], False);
		Ypos += YL;
		}
	else
		{
		Canvas.StrLen("TEST", XL, YL);
		Ypos += YL;
		}
}

simulated function DrawMenuGame(Canvas Canvas)
{
local float XL,YL;

	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;

	Canvas.StrLen(GameText, XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY * 0.5 - 0.5 * YL);
	Canvas.DrawText(GameText, False);
}

simulated function DrawMenuTimeLeft(Canvas Canvas)
{
local float Scale,XL,YL;
local Respawnables_PRI PRI;
local float X,Y;
local int i,s,TimeLength;
local string Time;

	PRI = Respawnables_PRI(PlayerOwner.PlayerReplicationInfo);
		
	X = Canvas.ClipX * 0.5 + 330;
	Y = Canvas.ClipY * 0.5 - 220;
	Scale = 0.6;
	
	if ( PRI.MenuCountdown < 10 )
		{
		Canvas.DrawColor = RedColor;
		X += 51 * Scale;
		}
	else
		Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Masked;
	
	Time = string(PRI.MenuCountdown);
	
	if ( InStr(Time, "11") != -1 )
		{
		X += 48 * Scale;
		}
	else if ( InStr(Time, "1") != -1 )
		{
		X += 24 * Scale;
		}
	
	TimeLength = len(Time);
	
	for (i=0;i<TimeLength;i++)
		{
		if ( left(Time,1) == "0" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 50 * Scale, 59 * Scale, 0, 0, 50.0, 59.0);
			X += 51 * Scale;
			}
		else if ( left(Time,1) == "1" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 26 * Scale, 59 * Scale, 54, 0, 26.0, 59.0);
			X += 27 * Scale;
			}
		else if ( left(Time,1) == "2" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 50 * Scale, 59 * Scale, 84, 0, 50.0, 59.0);
			X += 51 * Scale;
			}
		else if ( left(Time,1) == "3" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 50 * Scale, 59 * Scale, 138, 0, 50.0, 59.0);
			X += 51 * Scale;
			}
		else if ( left(Time,1) == "4" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 50 * Scale, 59 * Scale, 192, 0, 50.0, 59.0);
			X += 51 * Scale;
			}
		else if ( left(Time,1) == "5" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 50 * Scale, 59 * Scale, 246, 0, 50.0, 59.0);
			X += 51 * Scale;
			}
		else if ( left(Time,1) == "6" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 50 * Scale, 59 * Scale, 300, 0, 50.0, 59.0);
			X += 51 * Scale;
			}
		else if ( left(Time,1) == "7" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 50 * Scale, 59 * Scale, 354, 0, 50.0, 59.0);
			X += 51 * Scale;
			}
		else if ( left(Time,1) == "8" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 50 * Scale, 59 * Scale, 408, 0, 50.0, 59.0);
			X += 51 * Scale;
			}
		else if ( left(Time,1) == "9" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 50 * Scale, 59 * Scale, 462, 0, 50.0, 59.0);
			X += 51 * Scale;
			}
		s += 1;
		Time = right(Time, TimeLength - s);
		}
}

simulated function DrawMenu(Canvas Canvas)
{
local float Scale,XL,YL;
local Respawnables_PRI PRI;

	Scale = Canvas.ClipX / 1024;
	if ( Scale > 1 )
		Scale = 1;
	
	Canvas.DrawColor = WhiteColor;
	
	//Draw Nav element:
	Canvas.Style = ERenderStyle.STY_Masked;
	Canvas.SetPos(0, Canvas.ClipY - 128 * Scale);
	Canvas.DrawTile(Texture'reNavbase', 128 * Scale, 128 * Scale, 0, 0, 256, 256);
	
	DrawMenuFrame(Canvas);
	DrawMenuCategory(Canvas);
	DrawMenuMoney(Canvas);
	DrawMenuTimeLeft(Canvas);
	if ( Category == "Weapons" )
		DrawMenuWeapons(Canvas);
	else if ( Category == "Gear" )
		DrawMenuGear(Canvas);
	else if ( Category == "Mental" )
		DrawMenuMental(Canvas);
	else if ( Category == "Game" )
		DrawMenuGame(Canvas);
	//Assign menu variables to owners PRI class so mutators mutate function can read what item player wants to purchase:
	PRI = Respawnables_PRI(PlayerPawn(PawnOwner).PlayerReplicationInfo);
	PRI.Category = Category;
	PRI.NumInCategory = ItemNumber;
	
	//Track player input and draw arrow:
	Canvas.Style = ERenderStyle.STY_Masked;
	Canvas.DrawColor = GoldColor;
	if ( PlayerPawn(Owner).bWasBack )
		{
		Canvas.SetPos(0, Canvas.ClipY - 128 * Scale);
		Canvas.DrawTile(Texture'reNavDown', 128 * Scale, 128 * Scale, 0, 0, 256, 256);
		if ( !bKeyPressed )
			{
			if ( Category == "Weapons" && ItemNumber < 63 && WeaponsItem[ItemNumber + 1] != "" )
				{
				ItemNumber += 1;
				}
			else if ( Category == "Gear" && ItemNumber < 63 && GearsItem[ItemNumber + 1] != "" )
				{
				ItemNumber += 1;
				}
			else if ( Category == "Mental" && ItemNumber < 63 && MentalsItem[ItemNumber + 1] != "" )
				{
				ItemNumber += 1;
				}
			bKeyPressed = True;
			PlayerPawn(Owner).ClientPlaySound(Sound'UMenu.LittleSelect', , true);
			}
		}
	else if ( PlayerPawn(Owner).bWasForward )
		{
		Canvas.SetPos(0, Canvas.ClipY - 128 * Scale);
		Canvas.DrawTile(Texture'reNavUp', 128 * Scale, 128 * Scale, 0, 0, 256, 256);
		if ( !bKeyPressed )
			{
			if ( ItemNumber > 0 )
				{
				ItemNumber -= 1;
				}
			bKeyPressed = True;
			PlayerPawn(Owner).ClientPlaySound(Sound'UMenu.LittleSelect', , true);
			}
		}
	else if ( PlayerPawn(Owner).bWasLeft )	//!!!!Player used RIGHT arrow - EPIC fail!!!!
		{
		Canvas.SetPos(0, Canvas.ClipY - 128 * Scale);
		Canvas.DrawTile(Texture'reNavRight', 128 * Scale, 128 * Scale, 0, 0, 256, 256);
		if ( !bKeyPressed )
			{
			if ( Category == "Weapons" )
				Category = "Gear";
			else if ( Category == "Gear" )
				Category = "Mental";
			else if ( Category == "Mental" )
				Category = "Game";
			bKeyPressed = True;
			ItemNumber = 0;
			PlayerPawn(Owner).ClientPlaySound(Sound'UMenu.LittleSelect', , true);
			}
		}
	else if ( PlayerPawn(Owner).bWasRight )  //!!!!Player used LEFT arrow - EPIC fail!!!!
		{
		Canvas.SetPos(0, Canvas.ClipY - 128 * Scale);
		Canvas.DrawTile(Texture'reNavLeft', 128 * Scale, 128 * Scale, 0, 0, 256, 256);
		if ( !bKeyPressed )
			{
			if ( Category == "Game" )
				Category = "Mental";
			else if ( Category == "Mental" )
				Category = "Gear";
			else if ( Category == "Gear" )
				Category = "Weapons";
			bKeyPressed = True;
			ItemNumber = 0;
			PlayerPawn(Owner).ClientPlaySound(Sound'UMenu.LittleSelect', , true);
			}
		}
	else
		bKeyPressed = False;
		
	//bJustFired?? to purchase??
}

simulated function DrawSyncStep(Canvas Canvas)
{
local float XL,YL;
local string SyncText;

	SyncText = "Contacting database...";
	
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.bCenter = True;
	Canvas.StrLen(SyncText, XL, YL);
	Canvas.SetPos(0, Canvas.ClipY * 0.5 - 0.5 * YL);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = SyncColor; 
	Canvas.DrawText(SyncText, False);
	Canvas.bCenter = True;
}

simulated function DrawStatus(Canvas Canvas)
{
//TEMP:
local float XL,YL,Ypos,HealthLength,ItemX,ItemY;
local string HealthString, ArmorString;
local Respawnables_PRI PRI;
local inventory Inv;
local float ArmorAmount,ArmorCount,MaxArmor;

	PRI = Respawnables_PRI(PlayerPawn(PawnOwner).PlayerReplicationInfo);

	//Draw health bar:
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 160, Canvas.ClipY - 32);
	Canvas.DrawTile(Texture'reHealthIcon', 32, 32, 0, 0, 128.0, 128.0);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY - 32);
	Canvas.DrawTile(Texture'HealthBarB', 256, 32, 0, 0, 256.0, 32.0);
	HealthLength = PawnOwner.Health / PRI.MaxHealth;
	if ( HealthLength > 1 )
		HealthLength = 1;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY - 32);
	Canvas.DrawTile(Texture'HealthBarA', 256 * HealthLength, 32, 0, 0, 256.0 * HealthLength, 32.0);
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	HealthString = string(PawnOwner.Health)$"/"$string(int(PRI.MaxHealth));
	Canvas.StrLen(HealthString, XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL + 1, Canvas.ClipY - YL + 1 - 0.5 * (32 - YL));
	Canvas.DrawColor = WhiteColor * 0.1;
	Canvas.DrawText(HealthString, False);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY - YL - 0.5 * (32 - YL));
	Canvas.DrawColor = WhiteColor;
	Canvas.DrawText(HealthString, False);
	
	//Draw armor bar:
	//ArmorAmount,ArmorCount,MaxArmor
	MaxArmor = 200;
	for( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
		{ 
		if (Inv.bIsAnArmor) //Respawnables_Armor
			{
			ArmorAmount += Inv.Charge;
			}
		}
	if ( ArmorAmount > 0 )
		{
		Canvas.DrawColor = WhiteColor; 
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 160, Canvas.ClipY - 65);
		Canvas.DrawTile(Texture'reArmorIcon', 32, 32, 0, 0, 128.0, 128.0);
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY - 65);
		Canvas.DrawTile(Texture'HealthBarB', 256, 32, 0, 0, 256.0, 32.0);
		ArmorCount = ArmorAmount / MaxArmor;
		if ( ArmorCount > 1 )
			ArmorCount = 1;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY - 65);
		Canvas.DrawTile(Texture'ArmorBar', 256 * ArmorCount, 32, 0, 0, 256.0 * ArmorCount, 32.0);
		Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
		ArmorString = string(int(ArmorAmount))$"/"$string(int(MaxArmor));
		Canvas.StrLen(ArmorString, XL, YL);
		Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL + 1, Canvas.ClipY - YL + 1 - 33 - 0.5 * (32 - YL));
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.DrawText(ArmorString, False);
		Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY - YL - 33 - 0.5 * (32 - YL));
		Canvas.DrawColor = WhiteColor;
		Canvas.DrawText(ArmorString, False);
		}
	
	//Draw inventory items:
	ItemX = Canvas.ClipX - 64;
	ItemY = Canvas.ClipY * 0.5 - ( PRI.NumItems * 64 / 2 );
	if ( PRI.bHasTornado )
		{
		Canvas.SetPos(ItemX, ItemY);
		Canvas.DrawTile(Texture'reTornado', 64, 64, 0, 0, 64.0, 64.0);
		ItemY += 64;
		}
	if ( PRI.bHasShield )
		{
		Canvas.SetPos(ItemX, ItemY);
		Canvas.DrawTile(Texture'reShield', 64, 64, 0, 0, 64.0, 64.0);
		ItemY += 64;
		}
	if ( PRI.bHasDoubleDamage )
		{
		Canvas.SetPos(ItemX, ItemY);
		Canvas.DrawTile(Texture'reDoubleDamage', 64, 64, 0, 0, 64.0, 64.0);
		ItemY += 64;
		}
	if ( PRI.bHasHealthRegrow )
		{
		Canvas.SetPos(ItemX, ItemY);
		Canvas.DrawTile(Texture'reHealthRegrow', 64, 64, 0, 0, 64.0, 64.0);
		ItemY += 64;
		}
	
	//Draw temp PRI values
	Ypos = 64;
	Canvas.Font = MyFonts.GetSmallestFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.StrLen("TEST", XL, YL);
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText("Rank:"@PRI.Rank, False);
	Ypos += YL;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText("XP:"@PRI.XP, False);
	Ypos += YL;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText("Money:"@PRI.Money, False);
	Ypos += YL;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText("Frags:"@PRI.NumFragged, False);
	Ypos += YL;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText("MaxSpree:"@PRI.MaxSpree, False);
	Ypos += YL;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText("WS:"@PRI.WeaponString, False);
	Ypos += YL;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText("IS:"@PRI.InventoryString, False);
	Ypos += YL;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText("Time:"@PRI.TimePlayed, False);
	Ypos += YL;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText("Mhealth:"@PRI.MaxHealth, False);
	Ypos += YL;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText("ID:"@PRI.RespawnablesID, False);
}

simulated function DrawAmmo(Canvas Canvas)
{
local float XL,YL,AmmoScale;

	if ( PawnOwner.Weapon != None && PawnOwner.Weapon.AmmoType != None)
		{
		//175 pixels høj scala, startende 2 pixel oppe fra bund
		Canvas.Style = ERenderStyle.STY_Masked;
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - 32, Canvas.ClipY - 256);
		Canvas.DrawTile(Texture'reAmmoElementB', 32, 256, 0, 0, 32.0, 256.0);
		AmmoScale = float(PawnOwner.Weapon.AmmoType.AmmoAmount) / float(PawnOwner.Weapon.AmmoType.MaxAmmo);
		Canvas.SetPos(Canvas.ClipX - 32, Canvas.ClipY - 2 - ( 175 * AmmoScale ) );
		Canvas.DrawTile(Texture'reAmmoElementA', 32, 175 * AmmoScale, 0, 254 - (175 * AmmoScale),32.0, 175 * AmmoScale);
		if ( AmmoScale <= 0.1 )
			DrawLowAmmo(Canvas);
		DrawAmmoCount(Canvas);
		}
}

simulated function DrawLowAmmo(Canvas Canvas)
{
	Canvas.Style = ERenderStyle.STY_Masked;
	Canvas.SetPos(Canvas.ClipX - 256 - 32, Canvas.ClipY - 256 - 48);
	Canvas.DrawTile(Texture'reLowAmmo', 256, 256, 0, 0, 256.0, 256.0);
}

simulated function DrawAmmoCount(Canvas Canvas)
{
local float X,Y;
local int i,s,AmmoCountLength,MaxAmmoCountLength;
local string AmmoCount,MaxAmmoCount;
		
	X = Canvas.ClipX - 28;
	Y = Canvas.ClipY - 3;
	
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Masked;
	
	AmmoCount = string(PawnOwner.Weapon.AmmoType.AmmoAmount);
	MaxAmmoCount = string(PawnOwner.Weapon.AmmoType.MaxAmmo);
	
	AmmoCountLength = len(AmmoCount);
	MaxAmmoCountLength = len(MaxAmmoCount);
	
	for (i=0;i<AmmoCountLength;i++)
		{
		if ( left(AmmoCount,1) == "0" )
			{
			Y -= 18;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 18, 0, 238, 25.0, 18.0);
			}
		else if ( left(AmmoCount,1) == "1" )
			{
			Y -= 15;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 15, 0, 220, 25.0, 15.0);
			}
		else if ( left(AmmoCount,1) == "2" )
			{
			Y -= 16;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 16, 0, 201, 25.0, 16.0);
			}
		else if ( left(AmmoCount,1) == "3" )
			{
			Y -= 17;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 17, 0, 182, 25.0, 17.0);
			}
		else if ( left(AmmoCount,1) == "4" )
			{
			Y -= 19;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 19, 0, 162, 25.0, 19.0);
			}
		else if ( left(AmmoCount,1) == "5" )
			{
			Y -= 17;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 17, 0, 144, 25.0, 17.0);
			}
		else if ( left(AmmoCount,1) == "6" )
			{
			Y -= 17;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 17, 0, 125, 25.0, 17.0);
			}
		else if ( left(AmmoCount,1) == "7" )
			{
			Y -= 17;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 17, 0, 106, 25.0, 17.0);
			}
		else if ( left(AmmoCount,1) == "8" )
			{
			Y -= 17;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 18, 0, 87, 25.0, 18.0);
			}
		else if ( left(AmmoCount,1) == "9" )
			{
			Y -= 17;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 18, 0, 68, 25.0, 18.0);
			}
		s += 1;
		AmmoCount = right(AmmoCount, AmmoCountLength - s);
		}
	Y -= 14;
	Canvas.SetPos(X, Y);
	Canvas.DrawTile(Texture'reAmmoNumbers', 25, 14, 0, 53, 25.0, 14.0);
	s = 0;
	for (i=0;i<MaxAmmoCountLength;i++)
		{
		if ( left(MaxAmmoCount,1) == "0" )
			{
			Y -= 18;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 18, 0, 238, 25.0, 18.0);
			}
		else if ( left(MaxAmmoCount,1) == "1" )
			{
			Y -= 15;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 15, 0, 220, 25.0, 15.0);
			}
		else if ( left(MaxAmmoCount,1) == "2" )
			{
			Y -= 16;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 16, 0, 201, 25.0, 18.0);
			}
		else if ( left(MaxAmmoCount,1) == "3" )
			{
			Y -= 17;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 17, 0, 182, 25.0, 17.0);
			}
		else if ( left(MaxAmmoCount,1) == "4" )
			{
			Y -= 19;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 19, 0, 162, 25.0, 19.0);
			}
		else if ( left(MaxAmmoCount,1) == "5" )
			{
			Y -= 17;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 17, 0, 144, 25.0, 17.0);
			}
		else if ( left(MaxAmmoCount,1) == "6" )
			{
			Y -= 17;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 17, 0, 125, 25.0, 17.0);
			}
		else if ( left(MaxAmmoCount,1) == "7" )
			{
			Y -= 17;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 17, 0, 106, 25.0, 17.0);
			}
		else if ( left(MaxAmmoCount,1) == "8" )
			{
			Y -= 17;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 18, 0, 87, 25.0, 18.0);
			}
		else if ( left(MaxAmmoCount,1) == "9" )
			{
			Y -= 17;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reAmmoNumbers', 25, 18, 0, 68, 25.0, 18.0);
			}
		s += 1;
		MaxAmmoCount = right(MaxAmmoCount, MaxAmmoCountLength - s);
		}
}

simulated function DrawFragCount(Canvas Canvas)
{
local float X,Y;
local int i,s,ScoreLength;
local string Score;

	if ( PawnOwner.PlayerReplicationInfo == None )
		return;
		
	X = 0;
	Y = Canvas.ClipY - 60;
	
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Masked;
	Canvas.SetPos(X, Canvas.ClipY - 80);
	Canvas.DrawTile(Texture'reMoney', 64, 80, 0, 0, 168.0, 256.0);
	X += 64;
	
	Score = string(Respawnables_PRI(Pawn(Owner).PlayerReplicationInfo).Money);
	ScoreLength = len(Score);
	
	for (i=0;i<ScoreLength;i++)
		{
		if ( left(Score,1) == "0" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 50, 59, 0, 0, 50.0, 59.0);
			X += 51;
			}
		else if ( left(Score,1) == "1" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 26, 59, 54, 0, 26.0, 59.0);
			X += 27;
			}
		else if ( left(Score,1) == "2" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 50, 59, 84, 0, 50.0, 59.0);
			X += 51;
			}
		else if ( left(Score,1) == "3" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 50, 59, 138, 0, 50.0, 59.0);
			X += 51;
			}
		else if ( left(Score,1) == "4" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 50, 59, 192, 0, 50.0, 59.0);
			X += 51;
			}
		else if ( left(Score,1) == "5" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 50, 59, 246, 0, 50.0, 59.0);
			X += 51;
			}
		else if ( left(Score,1) == "6" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 50, 59, 300, 0, 50.0, 59.0);
			X += 51;
			}
		else if ( left(Score,1) == "7" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 50, 59, 354, 0, 50.0, 59.0);
			X += 51;
			}
		else if ( left(Score,1) == "8" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 50, 59, 408, 0, 50.0, 59.0);
			X += 51;
			}
		else if ( left(Score,1) == "9" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'reNumbers', 50, 59, 462, 0, 50.0, 59.0);
			X += 58;
			}
		s += 1;
		Score = right(Score, ScoreLength - s);
		}	
}

simulated function DrawGameSynopsis(Canvas Canvas)
{
}

simulated function DrawWeapons(Canvas Canvas)
{
}

simulated function DisplayProgressMessage( canvas Canvas )
{
	local int i;
	local float XL, YL, YOffset;
	local GameReplicationInfo GRI;

	PlayerOwner.ProgressTimeOut = FMin(PlayerOwner.ProgressTimeOut, Level.TimeSeconds + 8);
	Canvas.Style = ERenderStyle.STY_Normal;	

	Canvas.bCenter = True;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	if ( UTIntro(Level.Game) != None )
		YOffset = 64 * scale + 2 * YL;
	else if ( (MOTDFadeOutTime <= 0) || (Canvas.ClipY < 300) )
		YOffset = 64 * scale + 6 * YL;
	else
	{
		YOffset = 64 * scale + 6 * YL;
		GRI = PlayerOwner.GameReplicationInfo;
		if ( GRI != None )
		{
			if ( GRI.MOTDLine1 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine2 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine3 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine4 != "" )
				YOffset += YL;
		}
	}
	for (i=0; i<8; i++)
	{
		Canvas.SetPos(0, YOffset);
		Canvas.DrawColor = PlayerPawn(Owner).ProgressColor[i];
		Canvas.DrawText(PlayerPawn(Owner).ProgressMessage[i], False);
		YOffset += YL + 1;
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.bCenter = False;
	HUDSetup(Canvas);	
}

function DrawTalkFace(Canvas Canvas, int i, float YPos)
{
	if ( !bHideHUD && !PawnOwner.PlayerReplicationInfo.bIsSpectator )
	{
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.SetPos(FaceAreaOffset + 4*Scale, 4*Scale);
		Canvas.DrawTile(FaceTexture, YPos - 1*Scale, YPos - 1*Scale, 0, 0, FaceTexture.USize, FaceTexture.VSize);
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawColor = FaceColor;
		Canvas.SetPos(FaceAreaOffset, 0);
		Canvas.DrawTile(texture'LadrStatic.Static_a00', YPos + 7*Scale, YPos + 7*Scale, 0, 0, texture'LadrStatic.Static_a00'.USize, texture'LadrStatic.Static_a00'.VSize);
		Canvas.DrawColor = WhiteColor;
	}
}

function bool DrawSpeechArea( Canvas Canvas, float XL, float YL )
{
	local float YPos, Yadj;
	local float WackNumber;
	local int paneltype;

	YPos = FMax(YL*4 + 8, 70*Scale);
	Yadj = YPos + 7*Scale;
	YPos *=2;
	MinFaceAreaOffset = -1 * Yadj;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = HUDColor * MessageFadeTime;

	Canvas.SetPos(FaceAreaOffset, 0);
	Canvas.DrawTile(texture'LadrStatic.Static_a00', Yadj, Yadj, 0, 0, texture'LadrStatic.Static_a00'.USize, texture'LadrStatic.Static_a00'.VSize);

	WackNumber = 512*Scale - 64 + FaceAreaOffset; // 256*Scale - (512*Scale - (768*Scale - 64 + FaceAreaOffset));
	if ( !PlayerOwner.Player.Console.bTyping )
		paneltype = 0;
	else 
		{
		Canvas.StrLen("(>"@PlayerOwner.Player.Console.TypedStr$"_", XL, YL);
		if (XL < 768*Scale)
			paneltype = 1;
		else 
			paneltype = 2;
		}

	//Canvas.SetPos(Yadj + FaceAreaOffset, 0);
	//Canvas.DrawTile(FP1[paneltype], 256*Scale - FaceAreaOffset, YPos, 0, 0, FP1[paneltype].USize, FP1[paneltype].VSize);

	//Yadj += 256 * Scale;
	//Canvas.SetPos(Yadj, 0);
	//Canvas.DrawTile(FP2[paneltype], WackNumber, YPos, 0, 0, FP2[paneltype].USize, FP2[paneltype].VSize);

	//Canvas.SetPos(Yadj + WackNumber, 0);
	//Canvas.DrawTile(FP3[paneltype], 64, YPos, 0, 0, FP3[paneltype].USize, FP3[paneltype].VSize);
}

//========================================
// Master HUD render function.

simulated function PostRender( canvas Canvas )
{
	local float XL, YL, XPos, YPos, FadeValue;
	local string Message;
	local int M, i, j, k, XOverflow;
	local float OldOriginX;

	HUDSetup(canvas);
	
	if ( !bIDset )
		{
		if ( RespawnablesID == "N/A" )
			{
			CreateID();
			Respawnables_PRI(PlayerPawn(Owner).PlayerReplicationInfo).RespawnablesID = RespawnablesID;
			if ( Respawnables_PRI(PlayerPawn(Owner).PlayerReplicationInfo).RespawnablesID != "N/A" )
				{
				SaveConfig();
				bIDset = True;
				}
			}
		else
			Respawnables_PRI(PlayerPawn(Owner).PlayerReplicationInfo).RespawnablesID = RespawnablesID;
		}
	
	if ( (PawnOwner == None) || (PlayerOwner.PlayerReplicationInfo == None) )
		return;
		
	if ( !Respawnables_PRI(PlayerOwner.PlayerReplicationInfo).bStarted )
		{
		if ( !Respawnables_PRI(PlayerOwner.PlayerReplicationInfo).bSynced )
			{
			DrawSyncing(Canvas); 
			return;
			}
		else
			{
			DrawBackground(Canvas);
			DrawMenu(Canvas);
			return;
			}
		}

	if ( bShowInfo )
	{
		ServerInfo.RenderInfo( Canvas );
		return;
	}

	DrawTime(Canvas);
	
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	OldOriginX = Canvas.OrgX;
	// Master message short queue control loop.
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	Canvas.SetClip(768*Scale - 10, Canvas.ClipY);
	bDrawFaceArea = false;
	if ( !bHideFaces && !PlayerOwner.bShowScores && !bForceScores && !bHideHUD 
			&& !PawnOwner.PlayerReplicationInfo.bIsSpectator && (Scale >= 0.4) )
	{
		DrawSpeechArea(Canvas, XL, YL);
		bDrawFaceArea = (FaceTexture != None) && (FaceTime > Level.TimeSeconds);
		if ( bDrawFaceArea )
		{
			if ( !bHideHUD && ((PawnOwner.PlayerReplicationInfo == None) || !PawnOwner.PlayerReplicationInfo.bIsSpectator) )
				Canvas.SetOrigin( FMax(YL*4 + 8, 70*Scale) + 7*Scale + 6 + FaceAreaOffset, Canvas.OrgY );
		}
	}

	for (i=0; i<4; i++)
	{
		if ( ShortMessageQueue[i].Message != None )
		{
			j++;

			if ( bResChanged || (ShortMessageQueue[i].XL == 0) )
			{
				if ( ShortMessageQueue[i].Message.Default.bComplexString )
					Canvas.StrLen(ShortMessageQueue[i].Message.Static.AssembleString( 
											self,
											ShortMessageQueue[i].Switch,
											ShortMessageQueue[i].RelatedPRI,
											ShortMessageQueue[i].StringMessage), 
								   ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				else
					Canvas.StrLen(ShortMessageQueue[i].StringMessage, ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				Canvas.StrLen("TEST", XL, YL);
				ShortMessageQueue[i].numLines = 1;
				if ( ShortMessageQueue[i].YL > YL )
				{
					ShortMessageQueue[i].numLines++;
					for (k=2; k<4-i; k++)
					{
						if (ShortMessageQueue[i].YL > YL*k)
							ShortMessageQueue[i].numLines++;
					}
				}
			}

			// Keep track of the amount of lines a message overflows, to offset the next message with.
			Canvas.SetPos(6, 2 + YL * YPos);
			YPos += ShortMessageQueue[i].numLines;
			if ( YPos > 4 )
				break; 

			if ( ShortMessageQueue[i].Message.Default.bComplexString )
			{
				// Use this for string messages with multiple colors.
				ShortMessageQueue[i].Message.Static.RenderComplexMessage( 
					Canvas,
					ShortMessageQueue[i].XL,  YL,
					ShortMessageQueue[i].StringMessage,
					ShortMessageQueue[i].Switch,
					ShortMessageQueue[i].RelatedPRI,
					None,
					ShortMessageQueue[i].OptionalObject
					);				
			} 
			else
			{
				Canvas.DrawColor = ShortMessageQueue[i].Message.Default.DrawColor;
				Canvas.DrawText(ShortMessageQueue[i].StringMessage, False);
			}
		}
	}

	Canvas.DrawColor = WhiteColor;
	Canvas.SetClip(OldClipX, Canvas.ClipY);
	Canvas.SetOrigin(OldOriginX, Canvas.OrgY);

	if ( PlayerOwner.bShowScores || bForceScores )
	{
		if ( (PlayerOwner.Scoring == None) && (PlayerOwner.ScoringType != None) )
			PlayerOwner.Scoring = Spawn(PlayerOwner.ScoringType, PlayerOwner);
		if ( PlayerOwner.Scoring != None )
		{ 
			PlayerOwner.Scoring.OwnerHUD = self;
			PlayerOwner.Scoring.ShowScores(Canvas);
			if ( PlayerOwner.Player.Console.bTyping )
				DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);
			return;
		}
	}

	YPos = FMax(YL*4 + 8, 70*Scale);
	if ( bDrawFaceArea )
		DrawTalkFace( Canvas,0, YPos );
	if (j > 0) 
	{
		bDrawMessageArea = True;
		MessageFadeCount = 2;
	} 
	else 
		bDrawMessageArea = False;

	if ( !bHideCenterMessages )
	{
		// Master localized message control loop.
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message != None)
			{
				if (LocalMessages[i].Message.Default.bFadeMessage && Level.bHighDetailMode)
				{
					Canvas.Style = ERenderStyle.STY_Translucent;
					FadeValue = (LocalMessages[i].EndOfLife - Level.TimeSeconds);
					if (FadeValue > 0.0)
					{
						if ( bResChanged || (LocalMessages[i].XL == 0) )
						{
							if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
								LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
							else // ==2
								LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
							Canvas.Font = LocalMessages[i].StringFont;
							Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
							LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
						}
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.DrawColor = LocalMessages[i].DrawColor * (FadeValue/LocalMessages[i].LifeTime);
						Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
						Canvas.DrawText( LocalMessages[i].StringMessage, False );
					}
				} 
				else 
				{
					if ( bResChanged || (LocalMessages[i].XL == 0) )
					{
						if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
							LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
						else // == 2
							LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
						LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
					}
					Canvas.Font = LocalMessages[i].StringFont;
					Canvas.Style = ERenderStyle.STY_Normal;
					Canvas.DrawColor = LocalMessages[i].DrawColor;
					Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
					Canvas.DrawText( LocalMessages[i].StringMessage, False );
				}
			}
		}
	}
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( !PlayerOwner.bBehindView && (PawnOwner.Weapon != None) && (Level.LevelAction == LEVACT_None) )
	{
		Canvas.DrawColor = WhiteColor;
		PawnOwner.Weapon.PostRender(Canvas);
		if ( !PawnOwner.Weapon.bOwnsCrossHair )
			DrawCrossHair(Canvas, 0,0 );
	}

	if ( (PawnOwner != Owner) && PawnOwner.bIsPlayer )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.bCenter = true;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = CyanColor * TutIconBlink;
		Canvas.SetPos(4, Canvas.ClipY - 96 * Scale);
		Canvas.DrawText( LiveFeed$PawnOwner.PlayerReplicationInfo.PlayerName, true );
		Canvas.bCenter = false;
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = Style;
	}

	if ( bStartUpMessage && (Level.TimeSeconds < 5) )
	{
		bStartUpMessage = false;
		PlayerOwner.SetProgressTime(7);
	}
	if ( (PlayerOwner.ProgressTimeOut > Level.TimeSeconds) && !bHideCenterMessages )
		DisplayProgressMessage(Canvas);

	// Display MOTD
	if ( MOTDFadeOutTime > 0.0 )
		DrawMOTD(Canvas);
		 
	if( !bHideHUD )
	{
		if ( !PawnOwner.PlayerReplicationInfo.bIsSpectator )
		{
			Canvas.Style = Style;

			// Draw Ammo
			DrawAmmo(Canvas);
			
			// Draw Health/Armor status
			DrawStatus(Canvas);

			//Draw radar:
			if ( Respawnables_PRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasRadar )
				{
				ShowRaderBase(Canvas);
				ShowRadar(Canvas);
				}
			
			// Display current Weapon
			if ( PawnOwner.Weapon != None && CurrentWeapon != PawnOwner.Weapon )
				{
				bWeaponSwitched = True;
				CurrentWeapon = PawnOwner.Weapon;
				WeaponDrawColor.R = 255;
				WeaponDrawColor.G = 255;
				WeaponDrawColor.B = 255;
				}
			if ( bWeaponSwitched && PawnOwner.Weapon != None )
				{
				DrawWeaponName(Canvas);
				WeaponDrawColor.R -= 1;
				WeaponDrawColor.G -= 1;
				WeaponDrawColor.B -= 1;
				if ( WeaponDrawColor.R <= 0 )
					{
					WeaponDrawColor.R = 0;
					WeaponDrawColor.G = 0;
					WeaponDrawColor.B = 0;
					bWeaponSwitched = False;
					}
				}
			
			else if ( Level.bHighDetailMode
					&& (PawnOwner == PlayerOwner) && (PlayerOwner.Handedness == 2) )
			{
				// if weapon bar hidden and weapon hidden, draw weapon name when it changes
				if ( PawnOwner.PendingWeapon != None )
				{
					WeaponNameFade = 1.0;
					Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
					Canvas.DrawColor = PawnOwner.PendingWeapon.NameColor;
					Canvas.SetPos(Canvas.ClipX - 360 * Scale, Canvas.ClipY - 64 * Scale);
					Canvas.DrawText(PawnOwner.PendingWeapon.ItemName, False);
				}
				else if ( (Level.NetMode == NM_Client)  
						&& PawnOwner.IsA('TournamentPlayer') && (TournamentPlayer(PawnOwner).ClientPending != None) )
				{
					WeaponNameFade = 1.0;
					Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
					Canvas.DrawColor = TournamentPlayer(PawnOwner).ClientPending.NameColor;
					Canvas.SetPos(Canvas.ClipX - 360 * Scale, Canvas.ClipY - 64 * Scale);
					Canvas.DrawText(TournamentPlayer(PawnOwner).ClientPending.ItemName, False);
				}
				else if ( (WeaponNameFade > 0) && (PawnOwner.Weapon != None) )
				{
					Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
					Canvas.DrawColor = PawnOwner.Weapon.NameColor;
					if ( WeaponNameFade < 1 )
						Canvas.DrawColor = Canvas.DrawColor * WeaponNameFade;
					Canvas.SetPos(Canvas.ClipX - 360 * Scale, Canvas.ClipY - 64 * Scale);
					Canvas.DrawText(PawnOwner.Weapon.ItemName, False);
				}
			}
		DrawFragCount(Canvas);
		}
		// Team Game Synopsis
		if ( !bHideTeamInfo )
			DrawGameSynopsis(Canvas);

		// Display Identification Info
		if ( PawnOwner == PlayerOwner )
			DrawIdentifyInfo(Canvas);

		if ( HUDMutator != None )
			HUDMutator.PostRender(Canvas);

		if ( (PlayerOwner.GameReplicationInfo != None) && (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) ) 
		{
			if ( TimeMessageClass == None )
				TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

			if ( (PlayerOwner.GameReplicationInfo.RemainingTime <= 300)
			  && (PlayerOwner.GameReplicationInfo.RemainingTime != LastReportedTime) )
			{
				LastReportedTime = PlayerOwner.GameReplicationInfo.RemainingTime;
				if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 30 )
				{
					bTimeValid = ( bTimeValid || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) );	
					if ( PlayerOwner.GameReplicationInfo.RemainingTime == 30 )
						TellTime(5);
					else if ( bTimeValid && PlayerOwner.GameReplicationInfo.RemainingTime <= 10 )
						TellTime(16 - PlayerOwner.GameReplicationInfo.RemainingTime);
				}
				else if ( PlayerOwner.GameReplicationInfo.RemainingTime % 60 == 0 )
				{
					M = PlayerOwner.GameReplicationInfo.RemainingTime/60;
					TellTime(5 - M);
				}
			}
		}
	}
	if ( PlayerOwner.Player.Console.bTyping )
		DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);

	if ( PlayerOwner.bBadConnectionAlert && (PlayerOwner.Level.TimeSeconds > 5) )
	{
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - (64*Scale), Canvas.ClipY / 2);
		Canvas.DrawIcon(texture'DisconnectWarn', Scale);
	}
}

function Timer()
{
	local int i, j;

	if (!bDrawMessageArea)
	{
		if (MessageFadeCount > 0)
			MessageFadeCount--;
	}

	// Age the short message queue.
	for (i=0; i<4; i++)
	{
		// Purge expired messages.
		if ( (ShortMessageQueue[i].Message != None) && (Level.TimeSeconds >= ShortMessageQueue[i].EndOfLife) )
			ClearMessage(ShortMessageQueue[i]);
	}

	// Clean empty slots.
	for (i=0; i<3; i++)
	{
		if ( ShortMessageQueue[i].Message == None )
		{
			for (j=i; j<4; j++)
			{
				if ( ShortMessageQueue[j].Message != None )
				{
					CopyMessage(ShortMessageQueue[i],ShortMessageQueue[j]);
					ClearMessage(ShortMessageQueue[j]);
					break;
				}
			}
		}
	}

	// Age all localized messages.
	for (i=0; i<10; i++)
	{
		// Purge expired messages.
		if ( (LocalMessages[i].Message != None) && (Level.TimeSeconds >= LocalMessages[i].EndOfLife) )
			ClearMessage(LocalMessages[i]);
	}

	// Clean empty slots.
	for (i=0; i<9; i++)
	{
		if ( LocalMessages[i].Message == None )
		{
			CopyMessage(LocalMessages[i],LocalMessages[i+1]);
			ClearMessage(LocalMessages[i+1]);
		}
	}

	if ( (PlayerOwner == None) || (PawnOwner == None) || (PlayerOwner.GameReplicationInfo == None)
		|| (PawnOwner.PlayerReplicationInfo == None) )
		return;

	// Update the rank and spread.
	UpdateRankAndSpread();
}

function UpdateRankAndSpread()
{
local PlayerReplicationInfo PRI;
local int HighScore;
local int i, j;

	PlayerCount = 0;
	HighScore = -100;
	bTiedScore = False;
	Rank = 1;
	for (i=0; i<32; i++)
	{
		PRI = PlayerOwner.GameReplicationInfo.PRIArray[i];
		if ( (PRI != None) && (!PRI.bIsSpectator || PRI.bWaitingPlayer) )
		{
			PlayerCount++;
			if (PRI != PawnOwner.PlayerReplicationInfo)
			{
				if (PRI.Score > PawnOwner.PlayerReplicationInfo.Score)
					Rank += 1;
				else if (PRI.Score == PawnOwner.PlayerReplicationInfo.Score)
				{
					bTiedScore = True;
					if (PRI.Deaths < PawnOwner.PlayerReplicationInfo.Deaths)
						Rank += 1;
					else if (PRI.Deaths == PawnOwner.PlayerReplicationInfo.Deaths)
						if (PRI.PlayerID < PawnOwner.PlayerReplicationInfo.PlayerID)
							Rank += 1;
				}
				if (PRI.Score > HighScore)
					HighScore = PRI.Score;
			}
		}
	}
	Lead = int(PawnOwner.PlayerReplicationInfo.Score) - HighScore;
}

simulated function TellTime(int num)
{
	PlayerOwner.ReceiveLocalizedMessage( TimeMessageClass, Num );
}

simulated function Tick(float DeltaTime)
{
	local int i;

	Super.Tick(DeltaTime);

	IdentifyFadeTime = FMax(0.0, IdentifyFadeTime - DeltaTime);
	MOTDFadeOutTime = FMax(0.0, MOTDFadeOutTime - DeltaTime * 55);
	
	TutIconBlink += DeltaTime;
	if (TutIconBlink >= 0.5)
		TutIconBlink = 0.0;

	if ( bDrawFaceArea )
	{
		if ( FaceAreaOffset < 0 )
			FaceAreaOffset += DeltaTime * 600;
		if ( FaceAreaOffset > 0 )
			FaceAreaOffset = 0.0;
	} 
	else if ( FaceAreaOffset > MinFaceAreaOffset )
		FaceAreaOffset = FMax(FaceAreaOffset - DeltaTime * 600, MinFaceAreaOffset );

	if ( bDrawMessageArea )
	{
		if ( MessageFadeTime < 1.0 )
		{
			MessageFadeTime += DeltaTime * 8;
			if (MessageFadeTime > 1.0)
				MessageFadeTime = 1.0;
		}
	} 
	else if ( (MessageFadeTime > 0.0) && (MessageFadeCount == 0) )
	{
		MessageFadeTime -= DeltaTime * 2;
		if (MessageFadeTime < 0.0)
			MessageFadeTime = 0.0;
	}
	WeaponNameFade -= DeltaTime;
}

simulated function DrawMOTD(Canvas Canvas)
{
	local GameReplicationInfo GRI;
	local float XL, YL;
	local float InitialY;

	GRI = PlayerPawn(Owner).GameReplicationInfo;
	if ( (GRI == None) || (GRI.GameName == "Game") || (MOTDFadeOutTime <= 0) ) 
		return;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.Style = Style;
	Canvas.bCenter = true;
	Canvas.DrawColor = UnitColor * MOTDFadeOutTime * 0.5;
	InitialY = 64*Scale;
	Canvas.SetPos(0.0, InitialY);
	Canvas.StrLen("TEST", XL, YL);
	if ( Level.NetMode != NM_Standalone )
	{
		Canvas.DrawText(GRI.ServerName);
		if ( Canvas.ClipY >= 300 )
		{
			Canvas.SetPos(0.0, InitialY + 6*YL);
			Canvas.DrawText(GRI.MOTDLine1, true);
			Canvas.SetPos(0.0, InitialY + 7*YL);
			Canvas.DrawText(GRI.MOTDLine2, true);
			Canvas.SetPos(0.0, InitialY + 8*YL);
			Canvas.DrawText(GRI.MOTDLine3, true);
			Canvas.SetPos(0.0, InitialY + 9*YL);
			Canvas.DrawText(GRI.MOTDLine4, true);
		}
	}
	Canvas.DrawColor = UnitColor * MOTDFadeOutTime * 0.6;
	Canvas.SetPos(0.0, InitialY + YL);
	Canvas.DrawText(GRI.GameName, true);
	Canvas.SetPos(0.0, InitialY + 2*YL);
	Canvas.DrawText(MapTitleString2@Level.Title, true);
	if ( Canvas.ClipY >= 300 )
	{
		Canvas.SetPos(0.0, InitialY + 3*YL);
		Canvas.DrawText(AuthorString2@Level.Author, true);
		if (Level.IdealPlayerCount != "")
		{
			Canvas.SetPos(0.0, InitialY + 4*YL);
			Canvas.DrawText(PlayerCountString$Level.IdealPlayerCount, true);
		}
	}
	Canvas.bCenter = false;
}

simulated function DrawCrossHair( canvas Canvas, int X, int Y)
{
	local float XScale, PickDiff;
	local float XLength;
	local texture T;

 	if (Crosshair>=CrosshairCount) Return;
	if ( Canvas.ClipX < 512 )
		XScale = 0.5;
	else
		XScale = FMax(1, int(0.1 + Canvas.ClipX/640.0));
	PickDiff = Level.TimeSeconds - PickupTime;
	if ( PickDiff < 0.4 )
	{
		if ( PickDiff < 0.2 )
			XScale *= (1 + 5 * PickDiff);
		else
			XScale *= (3 - 5 * PickDiff);
	}
	XLength = XScale * 64.0;

	Canvas.bNoSmooth = False;
	if ( PlayerOwner.Handedness == -1 )
		Canvas.SetPos(0.503 * (Canvas.ClipX - XLength), 0.504 * (Canvas.ClipY - XLength));
	else if ( PlayerOwner.Handedness == 1 )
		Canvas.SetPos(0.497 * (Canvas.ClipX - XLength), 0.496 * (Canvas.ClipY - XLength));
	else
		Canvas.SetPos(0.5 * (Canvas.ClipX - XLength), 0.5 * (Canvas.ClipY - XLength));
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = 15 * CrosshairColor;

	T = CrossHairTextures[Crosshair];
	if( T == None )
		T = LoadCrosshair(Crosshair);

	Canvas.DrawTile(T, XLength, XLength, 0, 0, 64, 64);
	Canvas.bNoSmooth = True;
	Canvas.Style = Style;
}

simulated function DrawTypingPrompt( canvas Canvas, console Console )
{
	local string TypingPrompt;
	local float XL, YL, YPos, XOffset;
	local float MyOldClipX, OldClipY, OldOrgX, OldOrgY;

	MyOldClipX = Canvas.ClipX;
	OldClipY = Canvas.ClipY;
	OldOrgX = Canvas.OrgX;
	OldOrgY = Canvas.OrgY;

	Canvas.DrawColor = GreenColor;
	TypingPrompt = "(>"@Console.TypedStr$"_";
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen( "TEST", XL, YL );
	YPos = YL*4 + 8;
	if (PawnOwner.PlayerReplicationInfo.bIsSpectator || bHideHUD || bHideFaces)
		XOffset = 0;
	else
		XOffset = FMax(0,FaceAreaOffset + 15*Scale + YPos);
	Canvas.SetOrigin(XOffset, FMax(0,YPos + 7*Scale));
	Canvas.SetClip( 760*Scale, Canvas.ClipY );
	Canvas.SetPos( 0, 0 );
	Canvas.DrawText( TypingPrompt, false );
	Canvas.SetOrigin( OldOrgX, OldOrgY );
	Canvas.SetClip( MyOldClipX, OldClipY );
}

// Entry point for string messages.
simulated function Message( PlayerReplicationInfo PRI, coerce string Msg, name MsgType )
{
	local int i;
	local Class<LocalMessage> MessageClass;

	switch (MsgType)
	{
		case 'Say':
		case 'TeamSay':
			MessageClass = class'SayMessagePlus';
			break;
		case 'CriticalEvent':
			MessageClass = class'CriticalStringPlus';
			LocalizedMessage( MessageClass, 0, None, None, None, Msg );
			return;
		case 'DeathMessage':
			MessageClass = class'RedSayMessagePlus';
			break;
		case 'Pickup':
			PickupTime = Level.TimeSeconds;
		default:
			MessageClass = class'StringMessagePlus';
			break;
	}

	if ( ClassIsChildOf(MessageClass, class'SayMessagePlus') || 
				     ClassIsChildOf(MessageClass, class'TeamSayMessagePlus') )
	{
		FaceTexture = PRI.TalkTexture;
		if ( FaceTexture != None )
			FaceTime = Level.TimeSeconds + 3;
		if ( Msg == "" )
			return;
	} 
	for (i=0; i<4; i++)
	{
		if ( ShortMessageQueue[i].Message == None )
		{
			// Add the message here.
			ShortMessageQueue[i].Message = MessageClass;
			ShortMessageQueue[i].Switch = 0;
			ShortMessageQueue[i].RelatedPRI = PRI;
			ShortMessageQueue[i].OptionalObject = None;
			ShortMessageQueue[i].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
			if ( MessageClass.Default.bComplexString )
				ShortMessageQueue[i].StringMessage = Msg;
			else
				ShortMessageQueue[i].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
			return;
		}
	}

	// No empty slots.  Force a message out.
	for (i=0; i<3; i++)
		CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

	ShortMessageQueue[3].Message = MessageClass;
	ShortMessageQueue[3].Switch = 0;
	ShortMessageQueue[3].RelatedPRI = PRI;
	ShortMessageQueue[3].OptionalObject = None;
	ShortMessageQueue[3].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
	if ( MessageClass.Default.bComplexString )
		ShortMessageQueue[3].StringMessage = Msg;
	else
		ShortMessageQueue[3].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
}

simulated function bool DisplayMessages( canvas Canvas )
{
	return true;
}

simulated function float DrawNextMessagePart(Canvas Canvas, string MString, float XOffset, int YPos)
{
	local float XL, YL;

	Canvas.SetPos(4 + XOffset, YPos);
	Canvas.StrLen( MString, XL, YL );
	Canvas.DrawText( MString, false );
	return (XOffset + XL);
}

//================================================================================
// Identify Info

simulated function bool TraceIdentify(canvas Canvas)
{
	local actor Other;
	local vector HitLocation, HitNormal, StartTrace, EndTrace;

	StartTrace = PawnOwner.Location;
	StartTrace.Z += PawnOwner.BaseEyeHeight;
	EndTrace = StartTrace + vector(PawnOwner.ViewRotation) * 1000.0;
	Other = Trace(HitLocation, HitNormal, EndTrace, StartTrace, true);

	if ( Pawn(Other) != None )
	{
		if ( Pawn(Other).bIsPlayer && !Other.bHidden )
		{
			IdentifyTarget = Pawn(Other).PlayerReplicationInfo;
			IdentifyFadeTime = 3.0;
		}
	}
	else if ( (Other != None) && SpecialIdentify(Canvas, Other) )
		return false;

	if ( (IdentifyFadeTime == 0.0) || (IdentifyTarget == None) || IdentifyTarget.bFeigningDeath )
		return false;

	return true;
}

simulated function bool SpecialIdentify(Canvas Canvas, Actor Other )
{
	return false;
}

simulated function SetIDColor( Canvas Canvas, int type )
{
	Canvas.DrawColor = GreenColor;
	if ( type == 0 )
		Canvas.DrawColor.G = 160 * (IdentifyFadeTime / 3.0);
	else
		Canvas.DrawColor.G = 255 * (IdentifyFadeTime / 3.0);
}

simulated function DrawTwoColorID( canvas Canvas, string TitleString, string ValueString, int YStart )
{
	local float XL, YL, XOffset, X1;

	Canvas.Style = Style;
	Canvas.StrLen(TitleString$": ", XL, YL);
	X1 = XL;
	Canvas.StrLen(ValueString, XL, YL);
	XOffset = Canvas.ClipX/2 - (X1+XL)/2;
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas,0);
	XOffset += X1;
	Canvas.DrawText(TitleString);
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas,1);
	Canvas.DrawText(ValueString);
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
}
	
simulated function bool DrawIdentifyInfo(canvas Canvas)
{
	if ( !TraceIdentify(Canvas))
		return false;

	if( IdentifyTarget.PlayerName != "" )
	{
		Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
		DrawTwoColorID(Canvas,IdentifyName, IdentifyTarget.PlayerName, Canvas.ClipY - 256 * Scale);
	}
	return true;
}

//=====================================================================
// Deal with a localized message.

simulated function LocalizedMessage( class<LocalMessage> Message, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject, optional String CriticalString )
{
	local int i;

	if ( ClassIsChildOf( Message, class'PickupMessagePlus' ) )
		PickupTime = Level.TimeSeconds;

	if ( !Message.Default.bIsSpecial )
	{
		if ( ClassIsChildOf(Message, class'SayMessagePlus') || 
						 ClassIsChildOf(Message, class'TeamSayMessagePlus') )
		{
			FaceTexture = RelatedPRI_1.TalkTexture;
			if ( FaceTexture != None )
				FaceTime = Level.TimeSeconds + 3;
		} 
		// Find an empty slot.
		for (i=0; i<4; i++)
		{
			if ( ShortMessageQueue[i].Message == None )
			{
				ShortMessageQueue[i].Message = Message;
				ShortMessageQueue[i].Switch = Switch;
				ShortMessageQueue[i].RelatedPRI = RelatedPRI_1;
				ShortMessageQueue[i].OptionalObject = OptionalObject;
				ShortMessageQueue[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				if ( Message.Default.bComplexString )
					ShortMessageQueue[i].StringMessage = CriticalString;
				else
					ShortMessageQueue[i].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
				return;
			}

		}
		// No empty slots.  Force a message out.
		for (i=0; i<3; i++)
			CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

		ShortMessageQueue[3].Message = Message;
		ShortMessageQueue[3].Switch = Switch;
		ShortMessageQueue[3].RelatedPRI = RelatedPRI_1;
		ShortMessageQueue[3].OptionalObject = OptionalObject;
		ShortMessageQueue[3].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		if ( Message.Default.bComplexString )
			ShortMessageQueue[3].StringMessage = CriticalString;
		else
			ShortMessageQueue[3].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		return;
	} 
	else 
	{
		if ( CriticalString == "" )
			CriticalString = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		if ( Message.Default.bIsUnique )
		{
			for (i=0; i<10; i++)
			{
				if (LocalMessages[i].Message != None)
				{
					if ((LocalMessages[i].Message == Message) 
						|| (LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, 24, 640) 
								== Message.Static.GetOffset(Switch, 24, 640)) ) 
					{
						LocalMessages[i].Message = Message;
						LocalMessages[i].Switch = Switch;
						LocalMessages[i].RelatedPRI = RelatedPRI_1;
						LocalMessages[i].OptionalObject = OptionalObject;
						LocalMessages[i].LifeTime = Message.Default.Lifetime;
						LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
						LocalMessages[i].StringMessage = CriticalString;
						LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
						LocalMessages[i].XL = 0;
						return;
					}
				}
			}
		}
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message == None)
			{
				LocalMessages[i].Message = Message;
				LocalMessages[i].Switch = Switch;
				LocalMessages[i].RelatedPRI = RelatedPRI_1;
				LocalMessages[i].OptionalObject = OptionalObject;
				LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				LocalMessages[i].StringMessage = CriticalString;
				LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
				LocalMessages[i].LifeTime = Message.Default.Lifetime;
				LocalMessages[i].XL = 0;
				return;
			}
		}

		// No empty slots.  Force a message out.
		for (i=0; i<9; i++)
			CopyMessage(LocalMessages[i],LocalMessages[i+1]);

		LocalMessages[9].Message = Message;
		LocalMessages[9].Switch = Switch;
		LocalMessages[9].RelatedPRI = RelatedPRI_1;
		LocalMessages[9].OptionalObject = OptionalObject;
		LocalMessages[9].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		LocalMessages[9].StringMessage = CriticalString;
		LocalMessages[9].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
		LocalMessages[9].LifeTime = Message.Default.Lifetime;
		LocalMessages[9].XL = 0;
		return;
	}
}


// DRAW RADAR:
simulated function ShowRaderBase(Canvas C) 
{
	
	local float RadarWidth, PulseWidth, PulseBrightness;
	
	RadarScale = Default.RadarScale * 0.5;
	RadarWidth = 0.5 * RadarScale * C.ClipX;
	PulseWidth = RadarScale * C.ClipX;
	C.DrawColor = RadarColor;
	C.Style = ERenderStyle.STY_Translucent;
	
	PulseBrightness = FMax(0,(1 - 2*RadarPulse) * 255.0);
	C.DrawColor.R = PulseBrightness;
	C.DrawColor.G = PulseBrightness;
	C.DrawColor.B = PulseBrightness;
	C.SetPos(RadarPosX*C.ClipX - 0.5*PulseWidth,RadarPosY*C.ClipY+RadarWidth-0.5*PulseWidth);
	C.DrawTile(Texture'Radar', PulseWidth, PulseWidth, 0, 0, 142, 142);
	
	PulseWidth = RadarPulse * RadarScale * C.ClipX;
	C.DrawColor = RadarColor;
	C.SetPos(RadarPosX*C.ClipX - 0.5*PulseWidth,RadarPosY*C.ClipY+RadarWidth-0.5*PulseWidth);
	C.DrawTile(Texture'Radar', PulseWidth, PulseWidth, 0, 0, 142, 142);
	
	C.DrawColor = WhiteColor;
	C.SetPos(RadarPosX*C.ClipX - RadarWidth,RadarPosY*C.ClipY);
	C.DrawTile(Texture'RadarBorder', RadarWidth*2, RadarWidth*2, 0, 0, 142, 142);
}

simulated function ShowRadar(Canvas C) 
{
	
	local Pawn P;
	local float Dist, MaxDist, RadarWidth, PulseBrightness, Angle, DotSize, OffsetY, OffsetScale;
	local rotator Dir;
	local vector Start;
	
	LastDrawRadar = Level.TimeSeconds;
	RadarWidth = 0.5 * RadarScale * C.ClipX;
	DotSize = 24 * C.ClipX /1600;
	if (PawnOwner == None)
		Start = PlayerOwner.Location;
	else
		Start = PawnOwner.Location;
	
	MaxDist = 3000 * RadarPulse;
	//C.Style = ERenderStyle.STY_Translucent;
	OffsetY = RadarPosY + RadarWidth / C.ClipY;
	
	foreach AllActors(class'Pawn', P)
		if (P.Health > 0 && (P.IsA('Bot') || P.IsA('TournamentPlayer')))
                        {
			
			Dist = VSize(Start - P.Location);
			if (Dist < 3000) {
				if (Dist < MaxDist)
					PulseBrightness = 255 - 255 * Abs(Dist*0.00033 - RadarPulse);
				else
					PulseBrightness = 255 - 255 * Abs(Dist*0.00033 - RadarPulse - 1);
				if (P.IsA('Bot')) 
                                {
					C.DrawColor.R = PulseBrightness;
					C.DrawColor.G = 0;
					//C.DrawColor.G = PulseBrightness;
					C.DrawColor.B = 0;
				} 
                                else if (P.IsA('TournamentPlayer')) 
                                {
					C.DrawColor.R = 0;
					C.DrawColor.B = 0;
					C.DrawColor.G = PulseBrightness;
				}
				Dir = rotator(P.Location - Start);
				OffsetScale = RadarScale * Dist * 0.000167;
				Angle = ((Dir.Yaw - PlayerOwner.Rotation.Yaw) & 65535) * 6.2832 / 65536;
				C.SetPos(RadarPosX * C.ClipX + OffsetScale * C.ClipX * sin(Angle) - 0.5 * DotSize,
					OffsetY * C.ClipY - OffsetScale * C.ClipY * cos(Angle) - 0.5 * DotSize);
				C.DrawTile(Texture'Dots', DotSize, DotSize, 0, 0, 16, 16);
			}
		}            
}

function DrawTime( canvas Canvas )
{
local int Minutes, Seconds;
local float XL, YL;
local string Time;
local PlayerPawn PlayerOwner;

	
	Canvas.DrawColor = WhiteColor;
	PlayerOwner = PlayerPawn(Owner);
	
	Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
	Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
	
	if ( Seconds < 10 )
		Time = Minutes$":0"$Seconds;
	else
		Time = Minutes$":"$Seconds;
	
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen(Time, XL, YL);
	Canvas.SetPos(Canvas.ClipX - XL, 0);
	Canvas.DrawText(Time, true);	
}

//var string	CurrentWeapon;
//var bool	bWeaponSwitched;

function DrawWeaponName( canvas Canvas )
{
local float XL, YL;
	
	Canvas.DrawColor = WeaponDrawColor;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen(PawnOwner.Weapon.PickupMessage, XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY - 65 - YL);
	Canvas.DrawText(PawnOwner.Weapon.PickupMessage, true);
	Canvas.Style = ERenderStyle.STY_Normal;
}

defaultproperties
{
	Version="Beta 1.0"
	Copyright="(c)2014 by TheDane - All rights reserved."
	RespawnablesID="N/A"
	RadarScale=0.40
    RadarPosX=0.10
    RadarPosY=0.40
	LightCyanColor=(R=128,G=255,B=255,A=0)
    RadarColor=(R=0,G=126,B=0)
     VersionMessage="Version"
     PlayerCountString="Ideal Player Load:"
     MapTitleString="in"
     AuthorString="by"
     MapTitleString2="Map:"
     AuthorString2="Author:"
     RankString="Rank:"
     SpreadString="Spread:"
     CrosshairCount=9
     CrossHairs(0)="Botpack.CHair1"
     CrossHairs(1)="Botpack.CHair2"
     CrossHairs(2)="Botpack.CHair3"
     CrossHairs(3)="Botpack.CHair4"
     CrossHairs(4)="Botpack.CHair5"
     CrossHairs(5)="Botpack.CHair6"
     CrossHairs(6)="Botpack.CHair7"
     CrossHairs(7)="Botpack.CHair8"
     CrossHairs(8)="Botpack.CHair9"
     FP1(0)=Texture'Botpack.FacePanel.FacePanel1'
     FP1(1)=Texture'Botpack.FacePanel.FacePanel1b'
     FP1(2)=Texture'Botpack.FacePanel.FacePanel1a'
     FP2(0)=Texture'Botpack.FacePanel.FacePanel2'
     FP2(1)=Texture'Botpack.FacePanel.FacePanel2b'
     FP2(2)=Texture'Botpack.FacePanel.FacePanel2a'
     FP3(0)=Texture'Botpack.FacePanel.FacePanel3'
     FP3(1)=Texture'Botpack.FacePanel.FacePanel3b'
     FP3(2)=Texture'Botpack.FacePanel.FacePanel3a'
     bStartUpMessage=True
     bUseTeamColor=True
     Opacity=15
     HUDScale=1.000000
     StatusScale=1.000000
     WeaponScale=0.800000
     FavoriteHUDColor=(B=16)
     CrosshairColor=(G=16)
     Style=3
     WhiteColor=(R=255,G=255,B=255)
	 WeaponDrawColor=(R=255,G=255,B=255)
     RedColor=(R=255)
     GreenColor=(G=255)
     CyanColor=(G=255,B=255)
     UnitColor=(R=1,G=1,B=1)
     BlueColor=(B=255)
     GoldColor=(R=255,G=255)
     PurpleColor=(R=255,B=255)
     TurqColor=(G=128,B=255)
     GrayColor=(R=200,G=200,B=200)
     FaceColor=(R=50,G=50,B=50)
     IdentifyName="Name:"
     IdentifyHealth="Health:"
     IdentifyCallsign="Callsign:"
     LiveFeed="Live Feed from "
     ScoreTime=-10000000.000000
     ServerInfoClass=Class'Botpack.ServerInfo'
     FontInfoClass="Botpack.FontInfo"
     HUDConfigWindowType="UTMenu.UTChallengeHUDConfig"
	 Category="Weapons"
	WeaponsItem(0)="GES Bio Rifle"
	WeaponsInfo(0)="Paint your oponents in green goo!"
	WeaponPrice(0)=1000
	WeaponsText(0)=texture'reBioRifle'
	WeaponsCom(0)="mutate purchase biorifle"
	WeaponAlias(0)="!BR"
	WeaponsItem(1)="Rocket Launcher"
	WeaponsInfo(1)="Cause serious harm by firing rockets!"
	WeaponPrice(1)=5000
	WeaponsText(1)=texture'reRocketLauncher'
	WeaponsCom(1)="mutate purchase rocketlauncher"
	WeaponAlias(1)="!RL"
	WeaponsItem(2)="Flak Cannon"
	WeaponsInfo(2)="Fragments and grenades - oponents beware!"
	WeaponPrice(2)=7500
	WeaponsText(2)=texture'reFlakCannon'
	WeaponsCom(2)="mutate purchase flakcannon"
	WeaponAlias(2)="!FC"
	WeaponsItem(3)="Minigun"
	WeaponsInfo(3)="When these bullets spray - your oponents start to pray!"
	WeaponPrice(3)=4000
	WeaponsText(3)=texture'reMinigun'
	WeaponsCom(3)="mutate purchase minigun"
	WeaponAlias(3)="!MG"
	WeaponsItem(4)="Pulse Gun"
	WeaponsInfo(4)="Plasma ball or beam? Your enemy will scream!"
	WeaponPrice(4)=3500
	WeaponsText(4)=texture'rePulseRifle'
	WeaponsCom(4)="mutate purchase pulsegun"
	WeaponAlias(4)="!PG"
	WeaponsItem(5)="Razor Jack"
	WeaponsInfo(5)="Lethal blades - don't get in their way!"
	WeaponPrice(5)=3000
	WeaponsText(5)=texture'reRazorJack'
	WeaponsCom(5)="mutate purchase razorjack"
	WeaponAlias(5)="!RJ"
	WeaponsItem(6)="ASMD Shock Rifle"
	WeaponsInfo(6)="Lazer and shockball Yehaw!"
	WeaponPrice(6)=5000
	WeaponsText(6)=texture'reShockRifle'
	WeaponsCom(6)="mutate purchase shockrifle"
	WeaponAlias(6)="!SR"
	WeaponsItem(7)="Sniper Rifle"
	WeaponsInfo(7)="Zoom in and claim your oponents head!"
	WeaponPrice(7)=5000
	WeaponsText(7)=texture'reSniperRifle'
	WeaponsCom(7)="mutate purchase sniperrifle"
	WeaponAlias(7)="!SN"
	WeaponsItem(8)="Dispersion Pistol"
	WeaponsInfo(8)="Shoot small plasma balls against your enemy."
	WeaponPrice(8)=500
	WeaponsText(8)=texture'reDispersionPistol'
	WeaponsCom(8)="mutate purchase dispersionpistol"
	WeaponAlias(8)="!DP"
	WeaponsItem(9)="Chainsaw"
	WeaponsInfo(9)="Clear your path by sawing through those who blocks it!"
	WeaponPrice(9)=500
	WeaponsText(9)=texture'reChainsaw'
	WeaponsCom(9)="mutate purchase chainsaw"
	WeaponAlias(9)="!CS"
	WeaponsItem(10)="Stinger"
	WeaponsInfo(10)="This weapons realy lets you NAIL your enemy!"
	WeaponPrice(10)=3000
	WeaponsText(10)=texture'reStinger'
	WeaponsCom(10)="mutate purchase stinger"
	WeaponAlias(10)="!ST"
	WeaponsItem(11)="Translocator Device"
	WeaponsInfo(11)="Travel to the destination by just a click!"
	WeaponPrice(11)=10000
	WeaponsText(11)=texture'reTranslocator'
	WeaponsCom(11)="mutate purchase translocator"
	WeaponAlias(11)="!TL"
	WeaponsItem(12)="Grappling Hook Device"
	WeaponsInfo(12)="Travel to the destination by hook and a wire!"
	WeaponPrice(12)=10000
	WeaponsText(12)=texture'reGrapplingHook'
	WeaponsCom(12)="mutate purchase grapplinghook"
	WeaponAlias(12)="!GH"
	WeaponsItem(13)="UZI"
	WeaponsInfo(13)="Press fire to remove anything standing in your way!"
	WeaponPrice(13)=25000
	WeaponsText(13)=texture'reUZI'
	WeaponsCom(13)="mutate purchase uzi"
	WeaponAlias(13)="!UZ"
	WeaponsItem(14)="Double Enforcers"
	WeaponsInfo(14)="Upgrade your base weapon with an extra Enforcer!"
	WeaponPrice(14)=1500
	WeaponsText(14)=texture'reEnforcer'
	WeaponsCom(14)="mutate purchase doubleenforcer"
	WeaponAlias(14)="!DE"
	WeaponsItem(15)="Bazooka"
	WeaponsInfo(15)="Tell your enemy that you MEAN it!"
	WeaponPrice(15)=17500
	WeaponsText(15)=texture'reBazooka'
	WeaponsCom(15)="mutate purchase bazooka"
	WeaponAlias(15)="!BZ"
	GearsItem(0)="Radar Device"
	GearsInfo(0)="View the direction of your oponents!"
	GearsInfoB(0)="type 'mutate radar' to toggle the radar on/off."
	GearPrice(0)=10000
	GearsText(0)=texture'reRadar'
	GearsCom(0)="mutate purchase radar"
	GearAlias(0)="!RA"
	GearsItem(1)="Flashlight"
	GearsInfo(1)="Let there be light!"
	GearsInfoB(1)="type 'mutate light' to toggle the flashlight on/off."
	GearPrice(1)=500
	GearsText(1)=texture'reFlashlight'
	GearsCom(1)="mutate purchase flashlight"
	GearAlias(1)="!FL"
	GearsItem(2)="Body Armor"
	GearsInfo(2)="Grants you 75+ armor."
	GearPrice(2)=5000
	GearsText(2)=texture'reBodyArmor'
	GearsCom(2)="mutate purchase bodyarmor"
	GearAlias(2)="!BA"
	GearsItem(3)="Jump Boots"
	GearsInfo(3)="Enhanced jump height"
	GearsInfoB(3)="type 'mutate jump' to toggle the JumpBoots on/off."
	GearPrice(3)=500
	GearsText(3)=texture'reJumpBoots'
	GearsCom(3)="mutate purchase jumpboots"
	GearAlias(3)="!JB"
	GearsItem(4)="Shield Belt"
	GearsInfo(4)="Grants you 100+ armor."
	GearPrice(4)=10000
	GearsText(4)=texture'reShieldBelt'
	GearsCom(4)="mutate purchase shieldbelt"
	GearAlias(4)="!SB"
	GearsItem(5)="Thigh Pads"
	GearsInfo(5)="Grants you 25+ armor."
	GearPrice(5)=2000
	GearsText(5)=texture'reThighPads'
	GearsCom(5)="mutate purchase thighpads"
	GearAlias(5)="!TP"
	MentalsItem(0)="Reduced Damage"
	MentalsInfo(0)="Reduce all damage recieved by 25%"
	MentalPrice(0)=10000
	MentalsText(0)=texture'reReducedDamage'
	MentalsCom(0)="mutate purchase reduceddamage"
	MentalAlias(0)="!RD"
	MentalsItem(1)="Small Health Upgrade"
	MentalsInfo(1)="Upgrade your health by 10 points."
	MentalPrice(1)=1000
	MentalsText(1)=texture'reAddToLifeSmall'
	MentalsCom(1)="mutate purchase smallhealthupgrade"
	MentalAlias(1)="!SH"
	MentalsItem(2)="Medium Health Upgrade"
	MentalsInfo(2)="Upgrade your health by 25 points."
	MentalPrice(2)=2500
	MentalsText(2)=texture'reAddToLifeMedium'
	MentalsCom(2)="mutate purchase mediumhealthupgrade"
	MentalAlias(2)="!MH"
	MentalsItem(3)="Large Health Upgrade"
	MentalsInfo(3)="Upgrade your health by 50 points."
	MentalPrice(3)=5000
	MentalsText(3)=texture'reAddToLifeLarge'
	MentalsCom(3)="mutate purchase largehealthupgrade"
	MentalAlias(3)="!LH"
	GameText="Press 'ENTER' key to begin game!"
}
